/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class RemoveRefugeTool
extends ShapeTool {
    public RemoveRefugeTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove refuge";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removeRefuge(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemoveRefugeEdit(shape.getID()));
    }

    private class RemoveRefugeEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemoveRefugeEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemoveRefugeTool.this.editor.getScenario().addRefuge(this.id);
            RemoveRefugeTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemoveRefugeTool.this.editor.getScenario().removeRefuge(this.id);
            RemoveRefugeTool.this.editor.updateOverlays();
        }
    }
}

