/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rescuecore2.Timestep;
import rescuecore2.messages.control.KVTimestep;
import rescuecore2.misc.java.JavaTools;
import rescuecore2.score.ScoreFunction;
import rescuecore2.standard.components.StandardViewer;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.view.AnimatedWorldModelViewer;
import rescuecore2.view.RenderedObject;
import rescuecore2.view.ViewComponent;
import rescuecore2.view.ViewListener;

public class SampleViewer
extends StandardViewer {
    private static final int DEFAULT_FONT_SIZE = 20;
    private static final int PRECISION = 3;
    private static final String FONT_SIZE_KEY = "viewer.font-size";
    private static final String MAXIMISE_KEY = "viewer.maximise";
    private static final String TEAM_NAME_KEY = "viewer.team-name";
    private ScoreFunction scoreFunction;
    private ViewComponent viewer;
    private JLabel timeLabel;
    private JLabel scoreLabel;
    private JLabel teamLabel;
    private NumberFormat format;

    protected void postConnect() {
        super.postConnect();
        int fontSize = this.config.getIntValue(FONT_SIZE_KEY, 20);
        String teamName = this.config.getValue(TEAM_NAME_KEY, "");
        this.scoreFunction = this.makeScoreFunction();
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(3);
        JFrame frame = new JFrame("Viewer " + this.getViewerID() + " (" + ((StandardWorldModel)this.model).getAllEntities().size() + " entities)");
        this.viewer = new AnimatedWorldModelViewer();
        this.viewer.initialise(this.config);
        this.viewer.view(new Object[]{this.model});
        this.viewer.setPreferredSize(new Dimension(500, 500));
        this.timeLabel = new JLabel("Time: Not started", 0);
        this.teamLabel = new JLabel(teamName, 2);
        this.scoreLabel = new JLabel("Score: Unknown", 4);
        this.timeLabel.setBackground(Color.WHITE);
        this.timeLabel.setOpaque(true);
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont(0, fontSize));
        this.teamLabel.setBackground(Color.WHITE);
        this.teamLabel.setOpaque(true);
        this.teamLabel.setFont(this.timeLabel.getFont().deriveFont(0, fontSize));
        this.scoreLabel.setBackground(Color.WHITE);
        this.scoreLabel.setOpaque(true);
        this.scoreLabel.setFont(this.timeLabel.getFont().deriveFont(0, fontSize));
        frame.add((Component)this.viewer, "Center");
        JPanel labels = new JPanel(new GridLayout(1, 3));
        labels.add(this.teamLabel);
        labels.add(this.timeLabel);
        labels.add(this.scoreLabel);
        frame.add((Component)labels, "North");
        frame.pack();
        if (this.config.getBooleanValue(MAXIMISE_KEY, false)) {
            frame.setExtendedState(6);
        }
        frame.setVisible(true);
        this.viewer.addViewListener(new ViewListener(){

            public void objectsClicked(ViewComponent view, List<RenderedObject> objects) {
                for (RenderedObject next : objects) {
                    System.out.println(next.getObject());
                }
            }

            public void objectsRollover(ViewComponent view, List<RenderedObject> objects) {
            }
        });
    }

    protected void handleTimestep(final KVTimestep t) {
        super.handleTimestep(t);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SampleViewer.this.timeLabel.setText("Time: " + t.getTime());
                SampleViewer.this.scoreLabel.setText("Score: " + SampleViewer.this.format.format(SampleViewer.this.scoreFunction.score(SampleViewer.this.model, new Timestep(t.getTime()))));
                SampleViewer.this.viewer.view(new Object[]{SampleViewer.this.model, t.getCommands()});
                SampleViewer.this.viewer.repaint();
            }
        });
    }

    public String toString() {
        return "Sample viewer";
    }

    private ScoreFunction makeScoreFunction() {
        String className = this.config.getValue("score.function");
        ScoreFunction result = (ScoreFunction)JavaTools.instantiate((String)className, ScoreFunction.class);
        result.initialise(this.model, this.config);
        return result;
    }
}

