/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import rescuecore.CannotFindLocationException;
import rescuecore.Memory;
import rescuecore.objects.Building;
import rescuecore.objects.Humanoid;
import rescuecore.objects.Node;
import rescuecore.objects.Road;
import rescuecore.view.BuildingRenderer;
import rescuecore.view.ConvexHull;
import rescuecore.view.ConvexHullRenderer;
import rescuecore.view.HumanoidRenderer;
import rescuecore.view.MapRenderer;
import rescuecore.view.MemoryLayer;
import rescuecore.view.NodeRenderer;
import rescuecore.view.RenderTools;
import rescuecore.view.RoadRenderer;
import rescuecore.view.ScreenTransform;
import rescuecore.view.Text;
import rescuecore.view.TextRenderer;

public class Layer {
    protected Collection<Object> objects;
    private Map shapes;
    protected Map renderers;
    protected String name;
    protected boolean enabled;

    public static Layer createRoadLayer(Memory m) {
        MemoryLayer result = new MemoryLayer("Roads");
        result.addType(2);
        result.addRenderer(Road.class, RoadRenderer.ordinaryRoadRenderer());
        result.memoryChanged(m);
        return result;
    }

    public static Layer createNodeLayer(Memory m) {
        MemoryLayer result = new MemoryLayer("Nodes");
        result.addType(4);
        result.addRenderer(Node.class, NodeRenderer.ordinaryNodeRenderer());
        result.memoryChanged(m);
        return result;
    }

    public static Layer createBuildingLayer(Memory m) {
        MemoryLayer result = new MemoryLayer("Buildings");
        result.addType(32);
        result.addType(33);
        result.addType(34);
        result.addType(36);
        result.addType(35);
        result.addRenderer(Building.class, BuildingRenderer.ordinaryBuildingRenderer());
        result.memoryChanged(m);
        return result;
    }

    public static Layer createHumanoidLayer(Memory m) {
        MemoryLayer result = new MemoryLayer("Humanoids");
        result.addType(64);
        result.addType(66);
        result.addType(68);
        result.addType(67);
        result.addRenderer(Humanoid.class, HumanoidRenderer.ordinaryHumanoidRenderer());
        result.memoryChanged(m);
        return result;
    }

    public static Layer createLayer(Memory m, Object object, MapRenderer r, String name) {
        return Layer.createLayer(object, r, name);
    }

    public static Layer createLayer(Object object, MapRenderer r, String name) {
        Layer result = new Layer(name);
        result.addRenderer(object.getClass(), r);
        result.setObject(object);
        return result;
    }

    public static Layer createLayer(Memory m, Object[] objects, MapRenderer r, String name) {
        return Layer.createLayer(objects, r, name);
    }

    public static Layer createLayer(Object[] objects, MapRenderer r, String name) {
        Layer result = new Layer(name);
        for (int i = 0; i < objects.length; ++i) {
            result.addRenderer(objects[i].getClass(), r);
            result.addObject(objects[i]);
        }
        return result;
    }

    public static Layer createOverlayLayer(String name) {
        Layer result = new Layer(name);
        result.addRenderer(Shape.class, new ShapeRenderer());
        return result;
    }

    public static Layer createEmptyLayer(Memory m, String name) {
        return Layer.createEmptyLayer(name);
    }

    public static Layer createEmptyLayer(String name) {
        Layer result = new Layer(name);
        result.renderers = new HashMap();
        return result;
    }

    public Layer(Memory m, String name) {
        this(name);
    }

    public Layer(String name) {
        this.name = name;
        this.objects = new HashSet<Object>();
        this.shapes = new HashMap();
        this.renderers = new HashMap();
        this.enabled = true;
    }

    public String getName() {
        return this.name;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void memoryChanged(Memory m) {
    }

    public void addObject(Object o) {
        this.objects.add(o);
    }

    public void addObjects(Object[] os) {
        for (int i = 0; i < os.length; ++i) {
            this.objects.add(os[i]);
        }
    }

    public void addObjects(Collection os) {
        this.objects.addAll(os);
    }

    public void setObject(Object o) {
        this.removeAllObjects();
        this.addObject(o);
    }

    public void setObjects(Object[] os) {
        this.removeAllObjects();
        this.addObjects(os);
    }

    public void setObjects(Collection os) {
        this.removeAllObjects();
        this.addObjects(os);
    }

    public void removeObject(Object o) {
        this.objects.remove(o);
    }

    public void removeObjects(Object[] os) {
        for (int i = 0; i < os.length; ++i) {
            this.objects.remove(os[i]);
        }
    }

    public void removeObjects(Collection os) {
        this.objects.removeAll(os);
    }

    public void removeAllObjects() {
        this.objects.clear();
    }

    public void addRenderer(Class clazz, MapRenderer renderer) {
        this.renderers.put(clazz, renderer);
    }

    public void removeRenderer(Class clazz) {
        this.renderers.remove(clazz);
    }

    public void paint(Graphics g, int width, int height, ScreenTransform transform, Memory m) {
        this.paint((Graphics2D)g, transform, m);
    }

    public Object[] getObjectsAtPoint(Point p) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object next : this.objects) {
            Shape s = (Shape)this.shapes.get(next);
            if (s == null || !s.contains(p.x, p.y)) continue;
            result.add(next);
        }
        return result.toArray();
    }

    public Object[] getObjectsInArea(Rectangle2D r) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object next : this.objects) {
            Shape s = (Shape)this.shapes.get(next);
            if (s == null || !s.intersects(r)) continue;
            result.add(next);
        }
        return result.toArray();
    }

    private void paint(Graphics2D graphics, ScreenTransform transform, Memory memory) {
        RenderTools.setLineMode(graphics, 0, Color.black, 1);
        RenderTools.setFillMode(graphics, 0, Color.black);
        for (Object next : this.objects) {
            if (next == null) continue;
            Class<?> clazz = next.getClass();
            MapRenderer renderer = this.getRenderer(clazz);
            Graphics g = graphics.create();
            if (renderer == null || !renderer.canRender(next)) continue;
            try {
                this.shapes.put(next, renderer.render(next, memory, g, transform));
            }
            catch (CannotFindLocationException e) {
                System.out.println(e);
            }
        }
    }

    private MapRenderer getRenderer(Class clazz) {
        if (clazz == null) {
            return null;
        }
        MapRenderer result = (MapRenderer)this.renderers.get(clazz);
        if (result == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                result = this.getRenderer(interfaces[i]);
                if (result == null) continue;
                return result;
            }
            return this.getRenderer(clazz.getSuperclass());
        }
        return result;
    }

    public void registerDefaultRenderers() {
        this.renderers.put(Road.class, RoadRenderer.ordinaryRoadRenderer());
        this.renderers.put(Node.class, NodeRenderer.ordinaryNodeRenderer());
        this.renderers.put(Building.class, BuildingRenderer.ordinaryBuildingRenderer());
        this.renderers.put(Humanoid.class, HumanoidRenderer.ordinaryHumanoidRenderer());
        this.renderers.put(ConvexHull.class, ConvexHullRenderer.RED);
        this.renderers.put(Text.class, new TextRenderer());
    }

    private static class ShapeRenderer
    implements MapRenderer {
        private ShapeRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o instanceof Shape;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            RenderTools.setLineMode(g, 2, Color.CYAN, 1);
            RenderTools.setFillMode(g, 0, new Color(Color.CYAN.getRed(), Color.CYAN.getGreen(), Color.CYAN.getBlue(), 128));
            Shape s = (Shape)o;
            ((Graphics2D)g).fill(s);
            return s;
        }
    }
}

