/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import rescuecore.RescueObject;

public abstract class DebugEntry
implements Serializable {
    private int time;

    protected DebugEntry(int time) {
        this.time = time;
    }

    public int getTimestep() {
        return this.time;
    }

    public static class ObjectDebugEntry
    extends DebugEntry {
        private static final long serialVersionUID = -7542261088352191771L;
        private Object object;

        public ObjectDebugEntry(Object object, int time) {
            super(time);
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public String toString() {
            return "User object: " + this.object;
        }
    }

    public static class ArrayPropertyUpdateEntry
    extends PropertyUpdateEntry {
        private int[] newValue;

        public ArrayPropertyUpdateEntry(int id, int property, int[] value, int time) {
            super(id, property, time);
            this.newValue = value;
        }

        public int[] getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return "Array update: Object: " + this.objectID + " Property: " + this.property;
        }
    }

    public static class IntPropertyUpdateEntry
    extends PropertyUpdateEntry {
        private int newValue;

        public IntPropertyUpdateEntry(int id, int property, int value, int time) {
            super(id, property, time);
            this.newValue = value;
        }

        public int getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return "Integer update: Object: " + this.objectID + " Property: " + this.property;
        }
    }

    public static abstract class PropertyUpdateEntry
    extends DebugEntry {
        protected int property;
        protected int objectID;

        protected PropertyUpdateEntry(int objectID, int property, int time) {
            super(time);
            this.property = property;
            this.objectID = objectID;
        }

        public int getProperty() {
            return this.property;
        }

        public int getObjectID() {
            return this.objectID;
        }
    }

    public static class RescueObjectCollectionEntry
    extends DebugEntry {
        private Collection<RescueObject> objects;

        public RescueObjectCollectionEntry(Collection<RescueObject> objects, int time) {
            super(time);
            this.objects = new HashSet<RescueObject>(objects);
        }

        public Collection<RescueObject> getObjects() {
            return this.objects;
        }

        public String toString() {
            return "Object collection: " + this.objects.size() + " objects";
        }
    }

    public static class RescueObjectEntry
    extends DebugEntry {
        private RescueObject object;

        public RescueObjectEntry(RescueObject object, int time) {
            super(time);
            this.object = object;
        }

        public RescueObject getObject() {
            return this.object;
        }

        public String toString() {
            return "Object added: " + this.object;
        }
    }
}

