/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

public class LongUDPFragment
implements Comparable {
    private static final int MAGIC = 8;
    private int id;
    private int number;
    private int total;
    private byte[] data;

    public LongUDPFragment(int id, int number, int total, byte[] data) {
        this.id = id;
        this.number = number;
        this.total = total;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public LongUDPFragment(byte[] input) {
        int magic = input[0] << 8 | input[1];
        if (magic != 8) {
            System.err.println("Oh oh - we got a LongUDPFragment with a bad magic number (" + magic + " instead of " + 8 + ")");
        }
        this.id = input[2] << 8 | input[3];
        this.number = input[4] << 8 | input[5];
        this.total = input[6] << 8 | input[7];
        this.data = new byte[input.length - 8];
        System.arraycopy(input, 8, this.data, 0, this.data.length);
    }

    public String toString() {
        return "LongUDPFragment: " + this.id + " (" + (this.number + 1) + " of " + this.total + ")";
    }

    public int compareTo(Object o) {
        LongUDPFragment l = (LongUDPFragment)o;
        return this.number - l.number;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.data.length + 8];
        this.write(result, 0, 8);
        this.write(result, 2, this.id);
        this.write(result, 4, this.number);
        this.write(result, 6, this.total);
        System.arraycopy(this.data, 0, result, 8, this.data.length);
        return result;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getID() {
        return this.id;
    }

    public int getNumber() {
        return this.number;
    }

    public int getTotal() {
        return this.total;
    }

    private void write(byte[] buffer, int off, int value) {
        buffer[off] = (byte)(value >> 8 & 0xFF);
        buffer[off + 1] = (byte)(value & 0xFF);
    }
}

