/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import rescuecore.Memory;
import rescuecore.RescueConstants;
import rescuecore.RescueObject;

public class HashMemory
extends Memory {
    protected Map data = new HashMap();

    @Override
    public Memory copy() {
        HashMemory m = new HashMemory();
        for (RescueObject o : this.data.values()) {
            m.add(o.copy(), 0, RescueConstants.SOURCE_UNKNOWN);
        }
        return m;
    }

    @Override
    public RescueObject lookup(int id) {
        return (RescueObject)this.data.get(new Integer(id));
    }

    @Override
    public Collection<RescueObject> getAllObjects() {
        return new HashSet<RescueObject>(this.data.values());
    }

    @Override
    public void getObjectsOfType(Collection<RescueObject> result, int ... types) {
        block0: for (RescueObject next : this.data.values()) {
            int type = next.getType();
            for (int nextType : types) {
                if (type != nextType) continue;
                result.add(next);
                continue block0;
            }
        }
    }

    @Override
    public void add(RescueObject o, int timestamp, Object source) {
        this.data.put(new Integer(o.getID()), o);
        super.add(o, timestamp, source);
    }

    @Override
    public void remove(RescueObject o) {
        this.data.remove(new Integer(o.getID()));
        super.remove(o);
    }
}

