/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.geometry.spatialindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import rescuecore2.log.Logger;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.spatialindex.AbstractSpatialIndex;
import rescuecore2.misc.geometry.spatialindex.Indexable;
import rescuecore2.misc.geometry.spatialindex.NullRegion;
import rescuecore2.misc.geometry.spatialindex.RectangleRegion;
import rescuecore2.misc.geometry.spatialindex.Region;

public class BBTree
extends AbstractSpatialIndex {
    private static final int DEFAULT_MAX_CHILDREN = 3;
    private static final int DEFAULT_TIMING_POINTS = 50000;
    private static final int DEFAULT_TIMING_LINES = 50000;
    private static final int DEFAULT_TIMING_REGIONS = 1000;
    private Node root;
    private int maxChildren;

    public BBTree() {
        this(3);
    }

    public BBTree(int maxChildren) {
        this.maxChildren = maxChildren;
        this.root = new Branch();
    }

    public static void main(String[] args) {
        int i;
        int points = 50000;
        int lines = 50000;
        int regions = 1000;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if ("-p".equalsIgnoreCase(args[i2])) {
                points = Integer.parseInt(args[++i2]);
                continue;
            }
            if ("-l".equalsIgnoreCase(args[i2])) {
                lines = Integer.parseInt(args[++i2]);
                continue;
            }
            if ("-r".equalsIgnoreCase(args[i2])) {
                regions = Integer.parseInt(args[++i2]);
                continue;
            }
            System.out.println("Unrecognised option: " + args[i2]);
        }
        BBTree tree = new BBTree();
        long start = System.currentTimeMillis();
        for (i = 0; i < points; ++i) {
            Point2D p = new Point2D(Math.random(), Math.random());
            tree.insert(p);
        }
        for (i = 0; i < lines; ++i) {
            Point2D p1 = new Point2D(Math.random(), Math.random());
            Point2D p2 = new Point2D(Math.random(), Math.random());
            Line2D l = new Line2D(p1, p2);
            tree.insert(l);
        }
        tree.logTree();
        long fill = System.currentTimeMillis();
        for (int i3 = 0; i3 < regions; ++i3) {
            double xMin = Math.random();
            double yMin = Math.random();
            double xMax = Math.random();
            double yMax = Math.random();
            tree.getItemsInRegion(Math.min(xMin, xMax), Math.min(yMin, yMax), Math.max(xMin, xMax), Math.max(yMin, yMax));
        }
        long end = System.currentTimeMillis();
        long fillTime = fill - start;
        long fetchTime = end - fill;
        double fillAverage = (double)fillTime / (double)(points + lines);
        double fetchAverage = (double)fetchTime / (double)regions;
        System.out.println("Time to populate tree with " + points + " points and " + lines + " lines: " + fillTime + "ms (average " + fillAverage + "ms)");
        System.out.println("Time to read " + regions + " regions:  " + fetchTime + "ms (average " + fetchAverage + "ms)");
    }

    @Override
    public void insert(Indexable i) {
        Leaf newLeaf = new Leaf(i);
        Node insertPoint = this.findInsertionPoint(this.root, i.getBoundingRegion());
        if (insertPoint instanceof Leaf) {
            Branch b = new Branch();
            if (insertPoint.parent != null) {
                insertPoint.parent.insert(b);
                insertPoint.parent.remove(insertPoint);
            }
            b.insert(insertPoint);
            b.insert(newLeaf);
        } else {
            Branch b = (Branch)insertPoint;
            b.insert(newLeaf);
        }
        newLeaf.recomputeBounds();
    }

    @Override
    public Collection<Indexable> getItemsInRegion(Region region) {
        ArrayList<Indexable> result = new ArrayList<Indexable>();
        if (this.root != null) {
            Stack<Node> open = new Stack<Node>();
            open.push(this.root);
            while (!open.isEmpty()) {
                Node next = (Node)open.pop();
                if (!next.bounds.intersects(region)) continue;
                if (next instanceof Branch) {
                    open.addAll(((Branch)next).children);
                    continue;
                }
                if (!(next instanceof Leaf)) continue;
                Leaf l = (Leaf)next;
                if (!region.intersects(l.entry.getBoundingRegion())) continue;
                result.add(l.entry);
            }
        }
        return result;
    }

    public void logTree() {
        Logger.debug("BBTree");
        Logger.debug("Max children per node: " + this.maxChildren);
        Logger.debug("Tree depth: " + this.root.getDepth());
        this.root.log("  ");
    }

    private Node findInsertionPoint(Node parent, Region newRegion) {
        if (parent instanceof Leaf) {
            return parent;
        }
        Branch b = (Branch)parent;
        if (b.children.size() < this.maxChildren) {
            return b;
        }
        Node best = this.findLeastAreaEnlargement(b.children, newRegion);
        return this.findInsertionPoint(best, newRegion);
    }

    private Node findLeastAreaEnlargement(Collection<Node> nodes, Region newRegion) {
        Node best = null;
        double bestDiff = 0.0;
        for (Node next : nodes) {
            double diff = this.computeAreaEnlargement(next, newRegion);
            if (best != null && !(diff < bestDiff)) continue;
            best = next;
            bestDiff = diff;
        }
        return best;
    }

    private double computeAreaEnlargement(Node node, Region newRegion) {
        double oldArea = node.bounds instanceof RectangleRegion ? ((RectangleRegion)node.bounds).getArea() : 0.0;
        double newArea = this.cover(node.bounds, newRegion).getArea();
        return newArea - oldArea;
    }

    private RectangleRegion cover(Region ... regions) {
        return this.cover(Arrays.asList(regions));
    }

    private RectangleRegion cover(List<? extends Region> regions) {
        if (regions.isEmpty()) {
            throw new IllegalArgumentException("Cannot cover zero regions");
        }
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        for (Region region : regions) {
            if (region == null || region instanceof NullRegion) continue;
            xMin = Math.min(xMin, region.getXMin());
            xMax = Math.max(xMax, region.getXMax());
            yMin = Math.min(yMin, region.getYMin());
            yMax = Math.max(yMax, region.getYMax());
        }
        if (Double.isInfinite(xMin)) {
            return null;
        }
        return new RectangleRegion(xMin, yMin, xMax, yMax);
    }

    private class Leaf
    extends Node {
        Indexable entry;

        Leaf(Indexable entry) {
            this.entry = entry;
            this.bounds = entry.getBoundingRegion();
        }

        public String toString() {
            return "Leaf [" + this.bounds + "] (" + this.entry + ")";
        }

        @Override
        void log(String prefix) {
            Logger.debug(prefix + this.toString());
        }

        @Override
        void recomputeBounds() {
            if (this.parent != null) {
                this.parent.recomputeBounds();
            }
        }

        @Override
        int getDepth() {
            return 1;
        }
    }

    private class Branch
    extends Node {
        List<Node> children;

        Branch() {
            this.children = new ArrayList<Node>(BBTree.this.maxChildren);
        }

        void insert(Node child) {
            this.children.add(child);
            child.parent = this;
            this.bounds = BBTree.this.cover(new Region[]{this.bounds, child.bounds});
        }

        void remove(Node child) {
            this.children.remove(child);
            child.parent = null;
        }

        public String toString() {
            return "Branch [" + this.bounds + "] (" + this.children.size() + " children) {depth " + this.getDepth() + "}";
        }

        @Override
        void log(String prefix) {
            Logger.debug(prefix + this);
            String newPrefix = prefix + "  ";
            for (Node next : this.children) {
                next.log(newPrefix);
            }
        }

        @Override
        void recomputeBounds() {
            ArrayList<Region> childBounds = new ArrayList<Region>(this.children.size());
            for (Node next : this.children) {
                childBounds.add(next.bounds);
            }
            this.bounds = BBTree.this.cover(childBounds);
            if (this.parent != null) {
                this.parent.recomputeBounds();
            }
        }

        @Override
        int getDepth() {
            int max = 0;
            for (Node next : this.children) {
                max = Math.max(max, next.getDepth());
            }
            return max + 1;
        }
    }

    private abstract class Node {
        Region bounds = null;
        Branch parent = null;

        Node() {
        }

        abstract void recomputeBounds();

        abstract void log(String var1);

        abstract int getDepth();
    }
}

