/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc;

public abstract class WorkerThread
extends Thread {
    private volatile boolean running = true;
    private volatile boolean killed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws InterruptedException {
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            if (this.killed) {
                return;
            }
            this.killed = true;
        }
        if (Thread.currentThread() == this) {
            return;
        }
        this.interrupt();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setup();
        try {
            while (this.isRunning()) {
                try {
                    this.running = this.work();
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            return !this.killed && this.running;
        }
    }

    protected abstract boolean work() throws InterruptedException;

    protected void setup() {
    }

    protected void cleanup() {
    }
}

