/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.control;

import java.io.IOException;
import java.io.InputStream;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.AKAcknowledge;
import rescuecore2.messages.control.AKConnect;
import rescuecore2.messages.control.ControlMessageURN;
import rescuecore2.messages.control.EntityIDRequest;
import rescuecore2.messages.control.EntityIDResponse;
import rescuecore2.messages.control.GKConnectError;
import rescuecore2.messages.control.GKConnectOK;
import rescuecore2.messages.control.KAConnectError;
import rescuecore2.messages.control.KAConnectOK;
import rescuecore2.messages.control.KASense;
import rescuecore2.messages.control.KGAcknowledge;
import rescuecore2.messages.control.KGConnect;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.messages.control.KSConnectError;
import rescuecore2.messages.control.KSConnectOK;
import rescuecore2.messages.control.KSUpdate;
import rescuecore2.messages.control.KVConnectError;
import rescuecore2.messages.control.KVConnectOK;
import rescuecore2.messages.control.KVTimestep;
import rescuecore2.messages.control.SKAcknowledge;
import rescuecore2.messages.control.SKConnect;
import rescuecore2.messages.control.SKUpdate;
import rescuecore2.messages.control.Shutdown;
import rescuecore2.messages.control.VKAcknowledge;
import rescuecore2.messages.control.VKConnect;
import rescuecore2.registry.AbstractMessageFactory;

public final class ControlMessageFactory
extends AbstractMessageFactory<ControlMessageURN> {
    public static final ControlMessageFactory INSTANCE = new ControlMessageFactory();

    private ControlMessageFactory() {
        super(ControlMessageURN.class);
    }

    @Override
    public Message makeMessage(ControlMessageURN urn, InputStream data) throws IOException {
        switch (urn) {
            case KG_CONNECT: {
                return new KGConnect(data);
            }
            case KG_ACKNOWLEDGE: {
                return new KGAcknowledge(data);
            }
            case GK_CONNECT_OK: {
                return new GKConnectOK(data);
            }
            case GK_CONNECT_ERROR: {
                return new GKConnectError(data);
            }
            case SK_CONNECT: {
                return new SKConnect(data);
            }
            case SK_ACKNOWLEDGE: {
                return new SKAcknowledge(data);
            }
            case SK_UPDATE: {
                return new SKUpdate(data);
            }
            case KS_CONNECT_OK: {
                return new KSConnectOK(data);
            }
            case KS_CONNECT_ERROR: {
                return new KSConnectError(data);
            }
            case KS_UPDATE: {
                return new KSUpdate(data);
            }
            case KS_COMMANDS: {
                return new KSCommands(data);
            }
            case VK_CONNECT: {
                return new VKConnect(data);
            }
            case VK_ACKNOWLEDGE: {
                return new VKAcknowledge(data);
            }
            case KV_CONNECT_OK: {
                return new KVConnectOK(data);
            }
            case KV_CONNECT_ERROR: {
                return new KVConnectError(data);
            }
            case KV_TIMESTEP: {
                return new KVTimestep(data);
            }
            case AK_CONNECT: {
                return new AKConnect(data);
            }
            case AK_ACKNOWLEDGE: {
                return new AKAcknowledge(data);
            }
            case KA_CONNECT_OK: {
                return new KAConnectOK(data);
            }
            case KA_CONNECT_ERROR: {
                return new KAConnectError(data);
            }
            case KA_SENSE: {
                return new KASense(data);
            }
            case SHUTDOWN: {
                return new Shutdown(data);
            }
            case ENTITY_ID_REQUEST: {
                return new EntityIDRequest(data);
            }
            case ENTITY_ID_RESPONSE: {
                return new EntityIDResponse(data);
            }
        }
        Logger.warn("Unrecognised message urn: " + (Object)((Object)urn));
        return null;
    }
}

