/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import rescuecore2.log.LogException;
import rescuecore2.log.LogRecord;
import rescuecore2.log.RecordType;
import rescuecore2.messages.Command;
import rescuecore2.messages.Message;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;

public class PerceptionRecord
implements LogRecord {
    private int time;
    private EntityID entityID;
    private ChangeSet visible;
    private Collection<Command> communications;

    public PerceptionRecord(int time, EntityID id, ChangeSet visible, Collection<Command> communications) {
        this.time = time;
        this.entityID = id;
        this.visible = visible;
        this.communications = communications;
    }

    public PerceptionRecord(InputStream in) throws IOException, LogException {
        this.read(in);
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.PERCEPTION;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.entityID.getValue(), out);
        EncodingTools.writeInt32(this.time, out);
        this.visible.write(out);
        EncodingTools.writeInt32(this.communications.size(), out);
        for (Command next : this.communications) {
            EncodingTools.writeMessage((Message)next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException, LogException {
        this.entityID = new EntityID(EncodingTools.readInt32(in));
        this.time = EncodingTools.readInt32(in);
        this.visible = new ChangeSet();
        this.visible.read(in);
        this.communications = new ArrayList<Command>();
        int count = EncodingTools.readInt32(in);
        for (int i = 0; i < count; ++i) {
            Command c = (Command)EncodingTools.readMessage(in);
            if (c == null) {
                throw new LogException("Could not read message from stream");
            }
            this.communications.add(c);
        }
    }

    public int getTime() {
        return this.time;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public ChangeSet getChangeSet() {
        return this.visible;
    }

    public Collection<Command> getHearing() {
        return this.communications;
    }
}

