/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import rescuecore2.GUIComponent;
import rescuecore2.components.Component;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.ComponentInitialisationException;
import rescuecore2.components.ComponentLauncher;
import rescuecore2.components.TCPComponentLauncher;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigException;
import rescuecore2.connection.ConnectionException;
import rescuecore2.log.Logger;
import rescuecore2.misc.CommandLineOptions;
import rescuecore2.misc.java.JavaTools;
import rescuecore2.misc.java.LoadableTypeProcessor;
import rescuecore2.registry.Registry;

public final class LaunchComponents {
    private static final String NO_GUI_FLAG = "--nogui";

    private LaunchComponents() {
    }

    public static void main(String[] args) {
        Logger.setLogContext("launcher");
        Config config = new Config();
        boolean gui = true;
        try {
            args = CommandLineOptions.processArgs(args, config);
            ArrayList<String> toLaunch = new ArrayList<String>();
            for (String next : args) {
                if (NO_GUI_FLAG.equals(next)) {
                    gui = false;
                    continue;
                }
                toLaunch.add(next);
            }
            int port = config.getIntValue("kernel.port", 7000);
            String host = config.getValue("kernel.host", "localhost");
            LaunchComponents.processJarFiles(config);
            TCPComponentLauncher launcher = new TCPComponentLauncher(host, port, config);
            for (String next : toLaunch) {
                LaunchComponents.connect(launcher, next, gui);
            }
        }
        catch (IOException e) {
            Logger.error("Error connecting components", e);
        }
        catch (ConfigException e) {
            Logger.error("Configuration error", e);
        }
        catch (ConnectionException e) {
            Logger.error("Error connecting components", e);
        }
        catch (InterruptedException e) {
            Logger.error("Error connecting components", e);
        }
    }

    private static void processJarFiles(Config config) throws IOException {
        LoadableTypeProcessor processor = new LoadableTypeProcessor(config);
        processor.addFactoryRegisterCallbacks(Registry.SYSTEM_REGISTRY);
        processor.process();
    }

    private static void connect(ComponentLauncher launcher, String argLine, boolean gui) throws InterruptedException, ConnectionException {
        Component c;
        int index = argLine.indexOf("*");
        int count = 1;
        String className = argLine;
        if (index != -1) {
            String mult = argLine.substring(index + 1);
            count = "n".equals(mult) ? Integer.MAX_VALUE : Integer.parseInt(mult);
            className = argLine.substring(0, index);
        }
        Logger.info("Launching " + (count == Integer.MAX_VALUE ? "many" : Integer.valueOf(count)) + " instances of component '" + className + "'...");
        for (int i = 0; i < count && (c = JavaTools.instantiate(className, Component.class)) != null; ++i) {
            Logger.info("Launching instance " + (i + 1) + "...");
            try {
                c.initialise();
                launcher.connect(c);
                if (gui && c instanceof GUIComponent) {
                    GUIComponent g = (GUIComponent)((Object)c);
                    JFrame frame = new JFrame(g.getGUIComponentName());
                    frame.setContentPane(g.getGUIComponent());
                    frame.pack();
                    frame.setVisible(true);
                }
                Logger.info("success");
                continue;
            }
            catch (ComponentConnectionException e) {
                Logger.info("failed: " + e.getMessage());
                break;
            }
            catch (ComponentInitialisationException e) {
                Logger.info("failed: " + e);
                continue;
            }
            catch (ConnectionException e) {
                Logger.info("failed: " + e);
                break;
            }
        }
    }
}

