/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.simulator;

import firesimulator.util.Configuration;
import firesimulator.world.Building;
import firesimulator.world.FireBrigade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtinguishRequest {
    private static final Log LOG = LogFactory.getLog(ExtinguishRequest.class);
    public static final int REASON_OK = 1;
    public static final int REASON_OK_VIRTUAL = 2;
    public static final int REASON_FB_WAS_NULL = -1;
    public static final int REASON_TO_MUCH_WATER = -2;
    public static final int REASON_TANK_EMPTY = -3;
    public static final int REASON_OUT_OF_RANGE = -4;
    public static final String OK = "passed all tests";
    public static final String OK_VIRT = "is virtual mode";
    public static final String ER_FB_NULL = "firebrigade is null";
    public static final String ER_TO_MUCH = "firebrigade is exceeding limt";
    public static final String ER_EMPTY = "tank is empty";
    public static final String ER_RANGE = "target is out of range";
    public static final String UNKNOWN = "unknown code ";
    public static int MAX_WATER_PER_CYCLE;
    public static int MAX_DISTANCE;
    private FireBrigade source;
    private Building target;
    private int quantity;
    private static boolean DEBUG_VERBOSE;

    public ExtinguishRequest(FireBrigade source, Building target, int quantity) {
        this.target = target;
        this.source = source;
        this.quantity = quantity;
    }

    public void verbose(String msg) {
        if (DEBUG_VERBOSE) {
            LOG.debug((Object)msg);
        }
    }

    public int validate() {
        if (this.source == null && Configuration.isActive("virtual")) {
            return 2;
        }
        if (this.source == null) {
            return -1;
        }
        if (this.source.getWaterUsed() + this.quantity > MAX_WATER_PER_CYCLE) {
            return -2;
        }
        if (this.source.getWaterQuantity() < this.quantity) {
            return -3;
        }
        if (this.distance(this.source, this.target) > (double)MAX_DISTANCE) {
            return -4;
        }
        return 1;
    }

    public String getReason(int code) {
        switch (code) {
            case 1: {
                return OK;
            }
            case 2: {
                return OK_VIRT;
            }
            case -1: {
                return ER_FB_NULL;
            }
            case -4: {
                return ER_RANGE;
            }
            case -3: {
                return ER_EMPTY;
            }
            case -2: {
                return ER_TO_MUCH;
            }
        }
        return UNKNOWN + code;
    }

    private double distance(FireBrigade source2, Building target2) {
        double x = source2.getX() - target2.getX();
        double y = source2.getY() - target2.getY();
        return Math.sqrt(x * x + y * y);
    }

    public boolean execute() {
        this.verbose(this.toString());
        int result = this.validate();
        if (result < 0) {
            this.verbose("ERROR reason = " + this.getReason(result) + "\n");
            return false;
        }
        if (this.source != null) {
            this.source.addWaterUsed(this.quantity);
            this.source.setWaterQuantity(this.source.getWaterQuantity() - this.quantity);
        }
        this.target.setWaterQuantity(this.target.getWaterQuantity() + this.quantity);
        this.verbose("OK reason = " + this.getReason(result) + "\n");
        return true;
    }

    public FireBrigade getSource() {
        return this.source;
    }

    public String toString() {
        String fb;
        try {
            fb = "fb=" + this.source.getID();
        }
        catch (Exception e) {
            fb = "fb=null";
        }
        return "extinguish request; " + fb + ", target=" + this.target.getID() + ", quantity=" + this.quantity + " -> ";
    }

    static {
        DEBUG_VERBOSE = true;
    }
}

