/*
 * Decompiled with CFR 0.152.
 */
package traffic3.simulator;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import rescuecore2.log.Logger;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.gui.PanZoomListener;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.Edge;
import traffic3.manager.TrafficManager;
import traffic3.objects.TrafficAgent;
import traffic3.objects.TrafficArea;
import traffic3.objects.TrafficBlockade;
import traffic3.simulator.PathElement;

public class TrafficSimulatorGUI
extends JPanel {
    private static final Color SELECTED_AREA_COLOUR = new Color(0, 0, 255, 128);
    private static final Color AREA_OUTLINE_COLOUR = new Color(0, 0, 0);
    private static final Color BLOCKADE_OUTLINE_COLOUR = new Color(128, 0, 0);
    private static final Stroke PASSABLE_EDGE_STROKE = new BasicStroke(1.0f, 0, 2);
    private static final Stroke IMPASSABLE_EDGE_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Stroke SELECTED_AREA_OUTLINE_STROKE = new BasicStroke(3.0f, 0, 2);
    private static final Stroke BLOCKADE_STROKE = new BasicStroke(1.0f, 0, 2);
    private static final int PATH_NODE_SIZE = 5;
    private static final int PATH_SPECIAL_NODE_SIZE = 9;
    private static final int TICK_TIME_MS = 10;
    private static final double FORCE_GUI_FACTOR = 1000.0;
    private TrafficManager manager;
    private volatile boolean waitOnRefresh;
    private final Object lock = new Object();
    private CountDownLatch latch;
    private WorldView view;
    private JButton cont;
    private JCheckBox wait;
    private JCheckBox animate;
    private Timer timer;
    private Box verboseBox;

    public TrafficSimulatorGUI(TrafficManager manager) {
        super(new BorderLayout());
        this.manager = manager;
        this.waitOnRefresh = false;
        this.view = new WorldView();
        this.cont = new JButton("Continue");
        this.wait = new JCheckBox("Wait on refresh", this.waitOnRefresh);
        this.animate = new JCheckBox("Animate", false);
        this.verboseBox = Box.createVerticalBox();
        this.verboseBox.setBorder(BorderFactory.createTitledBorder("Verbose agents"));
        this.cont.setEnabled(false);
        this.cont.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = TrafficSimulatorGUI.this.lock;
                synchronized (object) {
                    if (TrafficSimulatorGUI.this.latch != null) {
                        TrafficSimulatorGUI.this.latch.countDown();
                    }
                }
                TrafficSimulatorGUI.this.cont.setEnabled(false);
            }
        });
        this.wait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrafficSimulatorGUI.this.waitOnRefresh = TrafficSimulatorGUI.this.wait.isSelected();
            }
        });
        this.animate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrafficSimulatorGUI.this.animate.isSelected()) {
                    TrafficSimulatorGUI.this.timer.start();
                } else {
                    TrafficSimulatorGUI.this.timer.stop();
                }
                TrafficSimulatorGUI.this.cont.setEnabled(false);
            }
        });
        Box buttons = Box.createHorizontalBox();
        buttons.add(this.wait);
        buttons.add(this.cont);
        buttons.add(this.animate);
        this.add((Component)this.view, "Center");
        this.add((Component)buttons, "South");
        this.add((Component)this.verboseBox, "East");
        this.timer = new Timer(10, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = TrafficSimulatorGUI.this.lock;
                synchronized (object) {
                    if (TrafficSimulatorGUI.this.latch != null) {
                        TrafficSimulatorGUI.this.latch.countDown();
                    }
                }
            }
        });
    }

    public void initialise() {
        this.view.initialise();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrafficSimulatorGUI.this.verboseBox.removeAll();
                Iterator<TrafficAgent> i$ = TrafficSimulatorGUI.this.manager.getAgents().iterator();
                while (i$.hasNext()) {
                    TrafficAgent next;
                    final TrafficAgent ta = next = i$.next();
                    final JCheckBox check = new JCheckBox("Agent " + ta.getHuman(), false);
                    check.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ta.setVerbose(check.isSelected());
                        }
                    });
                    TrafficSimulatorGUI.this.verboseBox.add(check);
                }
                TrafficSimulatorGUI.this.verboseBox.revalidate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.repaint();
        if (this.waitOnRefresh) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TrafficSimulatorGUI.this.timer.isRunning()) {
                        TrafficSimulatorGUI.this.cont.setEnabled(true);
                    }
                }
            });
            Object object = this.lock;
            synchronized (object) {
                this.latch = new CountDownLatch(1);
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Logger.error((String)"Error waiting for continue", (Throwable)e);
            }
        }
    }

    public void setWaitOnRefresh(boolean b) {
        this.waitOnRefresh = b;
    }

    private class WorldView
    extends JComponent {
        private ScreenTransform transform;
        private TrafficArea selectedArea;
        private TrafficAgent selectedAgent;
        private Map<Shape, TrafficArea> areas;
        private Map<Shape, TrafficAgent> agents;

        public void initialise() {
            RectangularShape bounds = null;
            for (TrafficArea area : TrafficSimulatorGUI.this.manager.getAreas()) {
                Rectangle2D r = area.getArea().getShape().getBounds2D();
                if (bounds == null) {
                    bounds = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                    continue;
                }
                Rectangle2D.union((Rectangle2D)bounds, r, (Rectangle2D)bounds);
            }
            this.transform = new ScreenTransform(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
            new PanZoomListener((JComponent)this).setScreenTransform(this.transform);
            this.selectedArea = null;
            this.areas = new HashMap<Shape, TrafficArea>();
            this.agents = new HashMap<Shape, TrafficAgent>();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Point p = e.getPoint();
                    WorldView.this.selectedArea = null;
                    WorldView.this.selectedAgent = null;
                    for (Map.Entry next : WorldView.this.areas.entrySet()) {
                        if (!((Shape)next.getKey()).contains(p)) continue;
                        WorldView.this.selectedArea = (TrafficArea)next.getValue();
                    }
                    for (Map.Entry next : WorldView.this.agents.entrySet()) {
                        if (!((Shape)next.getKey()).contains(p)) continue;
                        WorldView.this.selectedAgent = (TrafficAgent)next.getValue();
                    }
                    WorldView.this.repaint();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Logger.pushLogContext((String)"traffic3");
            try {
                int width = this.getWidth();
                int height = this.getHeight();
                Insets insets = this.getInsets();
                this.transform.rescale(width -= insets.left + insets.right, height -= insets.top + insets.bottom);
                Graphics2D copy = (Graphics2D)g.create(insets.left, insets.top, width, height);
                this.drawObjects(copy);
            }
            finally {
                Logger.popLogContext();
            }
        }

        private void drawObjects(Graphics2D g) {
            this.drawAreas((Graphics2D)g.create());
            this.drawAgents((Graphics2D)g.create());
            this.drawBlockades((Graphics2D)g.create());
        }

        private void drawAreas(Graphics2D g) {
            this.areas.clear();
            for (TrafficArea area : TrafficSimulatorGUI.this.manager.getAreas()) {
                Path2D.Double shape = new Path2D.Double();
                List edges = area.getArea().getEdges();
                Edge e = (Edge)edges.get(0);
                ((Path2D)shape).moveTo(this.transform.xToScreen((double)e.getStartX()), this.transform.yToScreen((double)e.getStartY()));
                for (Edge edge : edges) {
                    ((Path2D)shape).lineTo(this.transform.xToScreen((double)edge.getEndX()), this.transform.yToScreen((double)edge.getEndY()));
                }
                if (area == this.selectedArea) {
                    g.setColor(SELECTED_AREA_COLOUR);
                    g.fill(shape);
                    g.setColor(AREA_OUTLINE_COLOUR);
                    this.paintEdges(edges, g);
                } else {
                    g.setColor(AREA_OUTLINE_COLOUR);
                    this.paintEdges(edges, g);
                }
                this.areas.put(shape, area);
            }
        }

        private void paintEdges(List<Edge> edges, Graphics2D g) {
            for (Edge edge : edges) {
                if (edge.isPassable()) {
                    g.setStroke(PASSABLE_EDGE_STROKE);
                } else {
                    g.setStroke(IMPASSABLE_EDGE_STROKE);
                }
                Line2D line = edge.getLine();
                g.drawLine(this.transform.xToScreen(line.getOrigin().getX()), this.transform.yToScreen(line.getOrigin().getY()), this.transform.xToScreen(line.getEndPoint().getX()), this.transform.yToScreen(line.getEndPoint().getY()));
            }
        }

        private void drawBlockades(Graphics2D g) {
            g.setStroke(BLOCKADE_STROKE);
            g.setColor(BLOCKADE_OUTLINE_COLOUR);
            for (TrafficBlockade b : TrafficSimulatorGUI.this.manager.getBlockades()) {
                for (Line2D line : b.getLines()) {
                    int x1 = this.transform.xToScreen(line.getOrigin().getX());
                    int y1 = this.transform.yToScreen(line.getOrigin().getY());
                    int x2 = this.transform.xToScreen(line.getEndPoint().getX());
                    int y2 = this.transform.yToScreen(line.getEndPoint().getY());
                    g.drawLine(x1, y1, x2, y2);
                }
            }
        }

        private void drawAgents(Graphics2D g) {
            for (TrafficAgent agent : TrafficSimulatorGUI.this.manager.getAgents()) {
                double agentX = agent.getX();
                double agentY = agent.getY();
                double ellipseX1 = agentX - agent.getRadius();
                double ellipseY1 = agentY - agent.getRadius();
                double ellipseX2 = agentX + agent.getRadius();
                double ellipseY2 = agentY + agent.getRadius();
                double velocityX = agentX + agent.getVX() * 1000.0;
                double velocityY = agentY + agent.getVY() * 1000.0;
                double forceX = agentX + agent.getFX() * 1000.0;
                double forceY = agentY + agent.getFY() * 1000.0;
                int x = this.transform.xToScreen(agentX);
                int y = this.transform.yToScreen(agentY);
                int x1 = this.transform.xToScreen(ellipseX1);
                int y1 = this.transform.yToScreen(ellipseY1);
                int x2 = this.transform.xToScreen(ellipseX2);
                int y2 = this.transform.yToScreen(ellipseY2);
                int vx = this.transform.xToScreen(velocityX);
                int vy = this.transform.yToScreen(velocityY);
                int fx = this.transform.xToScreen(forceX);
                int fy = this.transform.yToScreen(forceY);
                int ellipseWidth = x2 - x1;
                int ellipseHeight = y1 - y2;
                g.setColor(agent == this.selectedAgent ? Color.orange : Color.red);
                Ellipse2D.Double shape = new Ellipse2D.Double(x1, y2, ellipseWidth, ellipseHeight);
                g.fill(shape);
                this.agents.put(shape, agent);
                if (agent == this.selectedAgent) {
                    ArrayList<PathElement> path = new ArrayList<PathElement>(this.selectedAgent.getPath());
                    if (this.selectedAgent.getCurrentElement() != null) {
                        path.add(0, this.selectedAgent.getCurrentElement());
                    }
                    if (path != null) {
                        Point2D goal = this.selectedAgent.getFinalDestination();
                        Point2D current = this.selectedAgent.getCurrentDestination();
                        g.setColor(Color.gray);
                        int lastX = x;
                        int lastY = y;
                        for (PathElement next : path) {
                            ArrayList<Point2D> waypoints = new ArrayList<Point2D>(next.getWaypoints());
                            Collections.reverse(waypoints);
                            for (Point2D p : waypoints) {
                                int nodeX = this.transform.xToScreen(p.getX());
                                int nodeY = this.transform.yToScreen(p.getY());
                                g.fillOval(nodeX - 2, nodeY - 2, 5, 5);
                                g.drawLine(lastX, lastY, nodeX, nodeY);
                                lastX = nodeX;
                                lastY = nodeY;
                            }
                        }
                        if (current != null) {
                            g.setColor(Color.YELLOW);
                            int nodeX = this.transform.xToScreen(current.getX());
                            int nodeY = this.transform.yToScreen(current.getY());
                            g.fillOval(nodeX - 4, nodeY - 4, 9, 9);
                            g.drawLine(x, y, nodeX, nodeY);
                        }
                        if (goal != null) {
                            g.setColor(Color.WHITE);
                            int nodeX = this.transform.xToScreen(goal.getX());
                            int nodeY = this.transform.yToScreen(goal.getY());
                            g.fillOval(nodeX - 4, nodeY - 4, 9, 9);
                        }
                    }
                }
                g.setColor(Color.blue);
                g.drawLine(x, y, vx, vy);
                g.setColor(Color.green);
                g.drawLine(x, y, fx, fy);
            }
        }
    }
}

