/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import rescuecore.Memory;
import rescuecore.view.MapRenderer;
import rescuecore.view.ScreenTransform;
import rescuecore.view.Text;

public class TextRenderer
implements MapRenderer {
    private Font f = new Font("Times", 1, 12);

    public void setFont(Font f) {
        this.f = f;
    }

    @Override
    public boolean canRender(Object o) {
        return o instanceof Text;
    }

    @Override
    public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
        FontMetrics fm = g.getFontMetrics(this.f);
        Text t = (Text)o;
        String s = t.getString();
        int x = transform.toScreenX(t.getX());
        int y = transform.toScreenY(t.getY());
        int width = fm.stringWidth(s);
        int height = fm.getHeight();
        g.setColor(Color.WHITE);
        g.drawString(s, x -= width / 2, y += height / 2);
        return new Rectangle(x, y, width, height);
    }
}

