/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.RescueConstants;
import rescuecore.RescueObject;
import rescuecore.commands.Command;

public class KAConnectOK
extends Command {
    private RescueObject[] knowledge;
    private int requestID;
    private int agentID;

    public KAConnectOK(int requestID, int agentID, RescueObject[] knowledge) {
        super(66);
        this.knowledge = knowledge;
        this.requestID = requestID;
        this.agentID = agentID;
    }

    public KAConnectOK(InputBuffer in) {
        super(66);
        this.read(in);
    }

    @Override
    public void read(InputBuffer in) {
        this.requestID = in.readInt();
        this.agentID = in.readInt();
        this.knowledge = in.readObjects(0, RescueConstants.SOURCE_INITIAL);
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.requestID);
        out.writeInt(this.agentID);
        out.writeObjects(this.knowledge);
    }

    public int getRequestID() {
        return this.requestID;
    }

    public int getAgentID() {
        return this.agentID;
    }

    public RescueObject[] getKnowledge() {
        return this.knowledge;
    }
}

