/*
 * Decompiled with CFR 0.152.
 */
package gis2;

import gis2.GMLWorldModelCreator;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.connection.TCPConnection;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.GKConnectOK;
import rescuecore2.messages.control.KGConnect;
import rescuecore2.messages.control.Shutdown;
import rescuecore2.misc.CommandLineOptions;
import rescuecore2.misc.java.LoadableTypeProcessor;
import rescuecore2.registry.Registry;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public final class GISServer {
    private static final long WAIT_TIME = 1000L;
    private ServerSocket server;
    private WorldModel<? extends Entity> world;
    private volatile boolean running;

    private GISServer(int port, WorldModel<? extends Entity> world) throws IOException {
        this.server = new ServerSocket(port);
        this.world = world;
        this.running = true;
    }

    public static void main(String[] args) {
        Config config = new Config();
        try {
            CommandLineOptions.processArgs((String[])args, (Config)config);
            int port = config.getIntValue("gis.port", 7001);
            GISServer.processJarFiles(config);
            GMLWorldModelCreator creator = new GMLWorldModelCreator();
            new GISServer(port, creator.buildWorldModel(config)).run();
            Logger.info((String)("GIS server listening on port " + port));
        }
        catch (Exception e) {
            Logger.fatal((String)"Error starting GIS server", (Throwable)e);
        }
    }

    private static void processJarFiles(Config config) throws IOException {
        LoadableTypeProcessor processor = new LoadableTypeProcessor(config);
        processor.addFactoryRegisterCallbacks(Registry.SYSTEM_REGISTRY);
        processor.process();
    }

    public void run() {
        while (this.running) {
            try {
                Socket socket = this.server.accept();
                new ServerThread(socket).start();
            }
            catch (IOException e) {
                Logger.error((String)"Error accepting connection", (Throwable)e);
                this.running = false;
            }
        }
    }

    private class ServerThread
    extends Thread
    implements ConnectionListener {
        private Socket socket;
        private boolean dead;

        public ServerThread(Socket socket) {
            this.socket = socket;
            this.dead = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TCPConnection c = null;
            try {
                c = new TCPConnection(this.socket);
            }
            catch (IOException e) {
                Logger.error((String)"Error starting TCPConnection", (Throwable)e);
                return;
            }
            c.startup();
            c.addConnectionListener((ConnectionListener)this);
            ServerThread serverThread = this;
            synchronized (serverThread) {
                while (!this.dead) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        this.dead = true;
                    }
                }
            }
            c.shutdown();
        }

        public void messageReceived(Connection c, Message msg) {
            if (msg instanceof KGConnect) {
                try {
                    c.sendMessage((Message)new GKConnectOK(GISServer.this.world.getAllEntities()));
                }
                catch (ConnectionException e) {
                    Logger.fatal((String)"Error sending message", (Throwable)e);
                    this.die();
                }
            }
            if (msg instanceof Shutdown) {
                this.die();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void die() {
            ServerThread serverThread = this;
            synchronized (serverThread) {
                this.dead = true;
                this.notifyAll();
            }
            GISServer.this.running = false;
        }
    }
}

