/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import java.io.IOException;
import org.util.xml.parse.ElementParser;

/**
 * parse space.
 * S ::= (#x20 | #x9 | #xD | #xA)+
 * <a href="http://www.fxis.co.jp/xmlcafe/tmp/rec-xml.html#NT-S">W3C REC-xml-980210</a>
 * @author masaru
 */
public class SpaceParser extends ParseElement {

    public boolean match(char c) {
        return isSpace(c);
    }

    @Override
        public int parse(int c, ElementParser parser) throws XMLParseException, IOException {
        int next_word_ = -1;
        int state = 0;
        while(true) {
            if(state == 0) {
                if(isSpace(c)) state = 1;
                else throw new XMLParseException("parse error: cannot read space("+(char)c+")");
            }else if(state == 1) {
                if(isSpace(c));
                else {
                    next_word_ = c;
                    break;
                }
            }
            c = parser.getChar();
        }
        return next_word_;
    }
    

}
