/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class RemovePoliceForceTool
extends ShapeTool {
    public RemovePoliceForceTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove police force";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removePoliceForce(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemovePoliceForceEdit(shape.getID()));
    }

    private class RemovePoliceForceEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemovePoliceForceEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemovePoliceForceTool.this.editor.getScenario().addPoliceForce(this.id);
            RemovePoliceForceTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemovePoliceForceTool.this.editor.getScenario().removePoliceForce(this.id);
            RemovePoliceForceTool.this.editor.updateOverlays();
        }
    }
}

