/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLShape;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.LineEdgeDecorator;

public class TogglePassableTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private Listener listener;
    private EdgeDecorator highlight = new LineEdgeDecorator(HIGHLIGHT_COLOUR);
    private GMLEdge selected;

    public TogglePassableTool(GMLEditor editor) {
        super(editor);
        this.listener = new Listener();
    }

    @Override
    public String getName() {
        return "Toggle passable";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.selected = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().repaint();
    }

    private void highlight(GMLEdge edge) {
        if (this.selected == edge) {
            return;
        }
        if (this.selected != null) {
            this.editor.getViewer().clearEdgeDecorator(this.selected);
        }
        this.selected = edge;
        if (this.selected != null) {
            this.editor.getViewer().setEdgeDecorator(this.highlight, this.selected);
        }
        this.editor.getViewer().repaint();
    }

    private void toggle() {
        boolean isPassable = !this.selected.isPassable();
        this.setPassable(this.selected, isPassable);
        this.editor.addEdit(new ToggleEdit(this.selected, isPassable));
    }

    private void setPassable(GMLEdge edge, boolean passable) {
        edge.setPassable(passable);
        Collection<GMLShape> attached = this.editor.getMap().getAttachedShapes(edge);
        Iterator<GMLShape> it = attached.iterator();
        GMLShape first = it.next();
        GMLShape second = it.next();
        if (passable) {
            first.setNeighbour(edge, (Integer)second.getID());
            second.setNeighbour(edge, (Integer)first.getID());
        } else {
            first.setNeighbour(edge, null);
            second.setNeighbour(edge, null);
        }
        this.editor.setChanged();
        this.editor.getViewer().repaint();
    }

    private class ToggleEdit
    extends AbstractUndoableEdit {
        private GMLEdge edge;
        private boolean newPassable;

        public ToggleEdit(GMLEdge edge, boolean newPassable) {
            this.edge = edge;
            this.newPassable = newPassable;
        }

        @Override
        public void undo() {
            super.undo();
            TogglePassableTool.this.setPassable(this.edge, !this.newPassable);
            TogglePassableTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            TogglePassableTool.this.setPassable(this.edge, this.newPassable);
            TogglePassableTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = TogglePassableTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            GMLEdge edge = TogglePassableTool.this.editor.getMap().findNearestEdge(c.getX(), c.getY());
            if (TogglePassableTool.this.editor.getMap().getAttachedShapes(edge).size() == 2) {
                TogglePassableTool.this.highlight(edge);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (TogglePassableTool.this.selected == null) {
                return;
            }
            if (e.getButton() == 1) {
                TogglePassableTool.this.toggle();
                TogglePassableTool.this.highlight(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = TogglePassableTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

