/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.Collection;
import java.util.EnumSet;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.messages.AKSpeak;
import rescuecore2.worldmodel.ChangeSet;
import sample.AbstractSampleAgent;

public class ChannelTestAgent
extends AbstractSampleAgent<Human> {
    private static final int CHANNEL = 4;
    private static final int N = 100;

    public String toString() {
        return "Channel test agent";
    }

    @Override
    protected void postConnect() {
        super.postConnect();
        Logger.info((String)("Channel test agent " + this.getID() + " connected"));
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        if (time == this.config.getIntValue("kernel.agents.ignoreuntil")) {
            this.sendSubscribe(time, new int[]{4});
        }
        if (this.me() instanceof FireBrigade) {
            for (int i = 0; i < 100; ++i) {
                this.say(i + 1, time);
            }
        }
        Logger.debug((String)("Time " + time));
        Logger.debug((String)("Heard " + heard.size() + " messages"));
        int failures = 100;
        int dropout = 0;
        for (Command next : heard) {
            if (!(next instanceof AKSpeak)) continue;
            AKSpeak speak = (AKSpeak)next;
            --failures;
            if (speak.getContent().length != 0) continue;
            ++dropout;
        }
        Logger.debug((String)(failures + " failed messages"));
        Logger.debug((String)(dropout + " dropout messages"));
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.POLICE_FORCE, StandardEntityURN.AMBULANCE_TEAM);
    }

    private void say(int messageLength, int time) {
        this.sendSpeak(time, 4, new byte[messageLength]);
    }
}

