/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigConstraint;

public class ConfigTree
extends JTree {
    private Config config;

    public ConfigTree(Config config) {
        this.config = config;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Config");
        ArrayList<String> keys = new ArrayList<String>(config.getAllKeys());
        Collections.sort(keys);
        this.buildModel(root, keys);
        this.setModel(new DefaultTreeModel(root));
        this.setEditable(true);
        this.setCellRenderer(new ConfigEntryCellRenderer());
        this.setCellEditor(new ConfigEntryCellEditor());
        this.setInvokesStopCellEditing(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private void buildModel(DefaultMutableTreeNode root, Collection<String> keys) {
        HashMap<String, DefaultMutableTreeNode> branches = new HashMap<String, DefaultMutableTreeNode>();
        for (String next : keys) {
            String[] branchNames = next.split("\\.");
            DefaultMutableTreeNode parent = root;
            StringBuilder branchName = new StringBuilder();
            for (int i = 0; i < branchNames.length - 1; ++i) {
                branchName.append(branchNames[i]);
                String name = branchName.toString();
                DefaultMutableTreeNode nextParent = (DefaultMutableTreeNode)branches.get(name);
                if (nextParent == null) {
                    nextParent = new DefaultMutableTreeNode(new ConfigCategoryNode(name));
                    branches.put(name, nextParent);
                    parent.add(nextParent);
                }
                branchName.append(".");
                parent = nextParent;
            }
            DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(new ConfigEntryNode(next, this.config.getValue(next)));
            parent.add(leaf);
        }
    }

    private final class ConfigEntryCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor,
    ActionListener {
        private JPanel panel = new JPanel(new BorderLayout());
        private JLabel label = new JLabel();
        private JTextField field = new JTextField();
        private DefaultMutableTreeNode node;
        private String key;

        private ConfigEntryCellEditor() {
            this.panel.add((Component)this.label, "Center");
            this.panel.add((Component)this.field, "East");
            this.field.addActionListener(this);
            this.node = null;
        }

        @Override
        public boolean isCellEditable(EventObject o) {
            if (o instanceof MouseEvent && o.getSource() instanceof JTree) {
                TreePath path;
                Object leaf;
                JTree tree = (JTree)o.getSource();
                MouseEvent e = (MouseEvent)o;
                if (e.getClickCount() > 1 && (leaf = (path = tree.getPathForLocation(e.getX(), e.getY())).getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                    Object content = ((DefaultMutableTreeNode)leaf).getUserObject();
                    return content instanceof ConfigEntryNode;
                }
            }
            return false;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object data, boolean selected, boolean expanded, boolean leaf, int row) {
            this.node = (DefaultMutableTreeNode)data;
            ConfigEntryNode entry = (ConfigEntryNode)this.node.getUserObject();
            this.key = entry.getKey();
            this.label.setText(this.key + ": ");
            this.field.setText(entry.getValue());
            return this.panel;
        }

        @Override
        public Object getCellEditorValue() {
            return new ConfigEntryNode(this.key, this.field.getText());
        }

        @Override
        public boolean stopCellEditing() {
            if (this.node != null) {
                String value = this.field.getText();
                this.node.setUserObject(new ConfigEntryNode(this.key, value));
                ConfigTree.this.config.setValue(this.key, value);
            }
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }
    }

    private final class ConfigEntryCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private ConfigEntryCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object o = node.getUserObject();
            this.setText(o.toString());
            this.setOpaque(false);
            this.setToolTipText(null);
            if (o instanceof ConfigEntryNode) {
                ConfigEntryNode entry = (ConfigEntryNode)o;
                String key = entry.getKey();
                StringBuilder problems = new StringBuilder();
                for (ConfigConstraint constraint : ConfigTree.this.config.getViolatedConstraints()) {
                    if (!constraint.getKeys().contains(key)) continue;
                    if (problems.length() != 0) {
                        problems.append("\n");
                    }
                    problems.append(constraint.getDescription());
                }
                if (problems.length() != 0) {
                    this.setBackground(Color.RED);
                    this.setOpaque(true);
                    this.setToolTipText(problems.toString());
                }
            }
            return this;
        }
    }

    private static final class ConfigEntryNode {
        private String key;
        private String value;

        private ConfigEntryNode(String key, String value) {
            this.key = key;
            this.value = value;
        }

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + ": " + this.value;
        }
    }

    private static final class ConfigCategoryNode {
        private String prefix;

        private ConfigCategoryNode(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

