/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.geometry.spatialindex;

import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.spatialindex.LineRegion;
import rescuecore2.misc.geometry.spatialindex.PointRegion;
import rescuecore2.misc.geometry.spatialindex.Region;
import rescuecore2.misc.geometry.spatialindex.Tools;

public class RectangleRegion
implements Region {
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;

    public RectangleRegion(double xMin, double yMin, double xMax, double yMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
        if (xMin > xMax) {
            this.xMin = xMax;
            this.xMax = xMin;
        }
        if (yMin > yMax) {
            this.yMin = yMax;
            this.yMax = yMin;
        }
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getYMin() {
        return this.yMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    public double getYMax() {
        return this.yMax;
    }

    public double getOverlapArea(RectangleRegion other) {
        if (!this.intersects(other)) {
            return 0.0;
        }
        double overlapXMin = Math.max(this.xMin, other.xMin);
        double overlapXMax = Math.min(this.xMax, other.xMax);
        double overlapYMin = Math.max(this.yMin, other.yMin);
        double overlapYMax = Math.min(this.yMax, other.yMax);
        return (overlapXMax - overlapXMin) * (overlapYMax - overlapYMin);
    }

    public double getArea() {
        return (this.xMax - this.xMin) * (this.yMax - this.yMin);
    }

    public String toString() {
        return "Rectangle region: " + this.xMin + ", " + this.yMin + " -> " + this.xMax + ", " + this.yMax;
    }

    public boolean equals(Object o) {
        if (o instanceof RectangleRegion) {
            RectangleRegion r = (RectangleRegion)o;
            return Tools.equal(this.xMin, r.xMin) && Tools.equal(this.xMax, r.xMax) && Tools.equal(this.yMin, r.yMin) && Tools.equal(this.yMax, r.yMax);
        }
        return false;
    }

    public int hashCode() {
        Double d = this.xMin;
        return d.hashCode();
    }

    @Override
    public boolean intersects(Region r) {
        if (r instanceof RectangleRegion) {
            RectangleRegion rect = (RectangleRegion)r;
            return !(rect.xMax < this.xMin || rect.xMin > this.xMax || rect.yMax < this.yMin) && !(rect.yMin > this.yMax);
        }
        if (r instanceof LineRegion) {
            LineRegion l = (LineRegion)r;
            return GeometryTools2D.clipToRectangle(l.getLine(), this.getXMin(), this.getYMin(), this.getXMax(), this.getYMax()) != null;
        }
        if (r instanceof PointRegion) {
            PointRegion p = (PointRegion)r;
            return !(p.getX() < this.xMin || p.getX() > this.xMax || p.getY() < this.yMin) && !(p.getY() > this.yMax);
        }
        return false;
    }

    @Override
    public boolean contains(Region r) {
        if (r instanceof RectangleRegion) {
            RectangleRegion rect = (RectangleRegion)r;
            return rect.xMin >= this.xMin && rect.xMax <= this.xMax && rect.yMin >= this.yMin && rect.yMax <= this.yMax;
        }
        if (r instanceof LineRegion) {
            LineRegion l = (LineRegion)r;
            return l.getXMin() >= this.xMin && l.getXMax() <= this.xMax && l.getYMin() >= this.yMin && l.getYMax() <= this.yMax;
        }
        if (r instanceof PointRegion) {
            PointRegion p = (PointRegion)r;
            return p.getX() >= this.xMin && p.getX() <= this.xMax && p.getY() >= this.yMin && p.getY() <= this.yMax;
        }
        return false;
    }
}

