/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DelegatingMap<K, V>
extends HashMap<K, V> {
    private Map<K, V> downstream;

    public DelegatingMap(Map<K, V> downstream) {
        this.downstream = downstream;
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.downstream.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value) || this.downstream.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        result.addAll(super.entrySet());
        for (Map.Entry<K, V> next : this.downstream.entrySet()) {
            if (super.containsKey(next.getKey())) continue;
            result.add(next);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DelegatingMap) {
            return super.equals(o) && ((Object)this.downstream).equals(((DelegatingMap)o).downstream);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Object result = super.get(key);
        if (result == null) {
            return this.downstream.get(key);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.downstream).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.downstream.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> result = new HashSet<K>();
        result.addAll(super.keySet());
        result.addAll(this.downstream.keySet());
        return result;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<V> values() {
        HashSet<V> result = new HashSet<V>();
        result.addAll(super.values());
        result.addAll(this.downstream.values());
        return result;
    }
}

