/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import rescuecore2.messages.AbstractMessage;
import rescuecore2.messages.Control;
import rescuecore2.messages.components.IntComponent;
import rescuecore2.messages.components.StringComponent;
import rescuecore2.messages.components.StringListComponent;
import rescuecore2.messages.control.ControlMessageURN;

public class AKConnect
extends AbstractMessage
implements Control {
    private IntComponent requestID = new IntComponent("Request ID");
    private IntComponent version = new IntComponent("Version");
    private StringComponent agentName = new StringComponent("Name");
    private StringListComponent requestedEntityTypes = new StringListComponent("Requested entity types");

    public AKConnect(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public AKConnect(int requestID, int version, String agentName, String ... requestedEntityTypes) {
        this();
        this.requestID.setValue(requestID);
        this.version.setValue(version);
        this.agentName.setValue(agentName);
        this.requestedEntityTypes.setValues(requestedEntityTypes);
    }

    private AKConnect() {
        super(ControlMessageURN.AK_CONNECT);
        this.addMessageComponent(this.requestID);
        this.addMessageComponent(this.version);
        this.addMessageComponent(this.agentName);
        this.addMessageComponent(this.requestedEntityTypes);
    }

    public int getVersion() {
        return this.version.getValue();
    }

    public int getRequestID() {
        return this.requestID.getValue();
    }

    public String getAgentName() {
        return this.agentName.getValue();
    }

    public List<String> getRequestedEntityTypes() {
        return this.requestedEntityTypes.getValues();
    }
}

