/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rescuecore2.messages.AbstractMessageComponent;
import rescuecore2.misc.EncodingTools;

public class StringListComponent
extends AbstractMessageComponent {
    private List<String> data;

    public StringListComponent(String name) {
        super(name);
        this.data = new ArrayList<String>();
    }

    public StringListComponent(String name, List<String> data) {
        super(name);
        this.data = new ArrayList<String>(data);
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.data);
    }

    public void setValues(List<String> newData) {
        this.data = new ArrayList<String>(newData);
    }

    public void setValues(String ... newData) {
        this.data = new ArrayList<String>();
        for (String s : newData) {
            this.data.add(s);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.data.size(), out);
        for (String next : this.data) {
            EncodingTools.writeString(next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.data.clear();
        int count = EncodingTools.readInt32(in);
        for (int i = 0; i < count; ++i) {
            this.data.add(EncodingTools.readString(in));
        }
    }

    public String toString() {
        return this.getName() + " = " + this.data.toString();
    }
}

