/*
 * Decompiled with CFR 0.152.
 */
package traffic3.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import rescuecore2.log.Logger;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;
import rescuecore2.standard.entities.Human;
import traffic3.manager.TrafficManager;
import traffic3.objects.TrafficArea;
import traffic3.objects.TrafficBlockade;
import traffic3.simulator.PathElement;
import traffic3.simulator.TrafficConstants;

public class TrafficAgent {
    private static final int D = 2;
    private static final int DEFAULT_POSITION_HISTORY_FREQUENCY = 60;
    private static final double NEARBY_THRESHOLD_SQUARED = 1000000.0;
    private final double[] destinationForce = new double[2];
    private final double[] agentsForce = new double[2];
    private final double[] wallsForce = new double[2];
    private final double[] location = new double[2];
    private final double[] velocity = new double[2];
    private final double[] force = new double[2];
    private List<WallInfo> blockingLines;
    private double radius;
    private double velocityLimit;
    private Point2D finalDestination;
    private Queue<PathElement> path;
    private PathElement currentPathElement;
    private Point2D currentDestination;
    private TrafficArea currentArea;
    private List<Point2D> positionHistory;
    private double totalDistance;
    private boolean savePositionHistory;
    private int positionHistoryFrequency;
    private int historyCount;
    private Human human;
    private TrafficManager manager;
    private boolean mobile;
    private boolean colocated;
    private boolean verbose;

    public TrafficAgent(Human human, TrafficManager manager, double radius, double velocityLimit) {
        this.human = human;
        this.manager = manager;
        this.radius = radius;
        this.velocityLimit = velocityLimit;
        this.path = new LinkedList<PathElement>();
        this.positionHistory = new ArrayList<Point2D>();
        this.savePositionHistory = true;
        this.historyCount = 0;
        this.positionHistoryFrequency = 60;
        this.mobile = true;
        this.blockingLines = new ArrayList<WallInfo>();
    }

    public Human getHuman() {
        return this.human;
    }

    public double getMaxVelocity() {
        return this.velocityLimit;
    }

    public void setMaxVelocity(double vLimit) {
        this.velocityLimit = vLimit;
    }

    public TrafficArea getArea() {
        return this.currentArea;
    }

    public List<Point2D> getPositionHistory() {
        return Collections.unmodifiableList(this.positionHistory);
    }

    public double getTravelDistance() {
        return this.totalDistance;
    }

    public void clearPositionHistory() {
        this.positionHistory.clear();
        this.historyCount = 0;
        this.totalDistance = 0.0;
    }

    public void setPositionHistoryFrequency(int n) {
        this.positionHistoryFrequency = n;
    }

    public void setPositionHistoryEnabled(boolean b) {
        this.savePositionHistory = b;
    }

    public double getX() {
        return this.location[0];
    }

    public double getY() {
        return this.location[1];
    }

    public double getFX() {
        return this.force[0];
    }

    public double getFY() {
        return this.force[1];
    }

    public double getVX() {
        return this.velocity[0];
    }

    public double getVY() {
        return this.velocity[1];
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setPath(List<PathElement> steps) {
        if (steps == null || steps.isEmpty()) {
            this.clearPath();
            return;
        }
        this.path.clear();
        this.path.addAll(steps);
        this.finalDestination = steps.get(steps.size() - 1).getGoal();
        this.currentDestination = null;
        this.currentPathElement = null;
    }

    public void clearPath() {
        this.finalDestination = null;
        this.currentDestination = null;
        this.currentPathElement = null;
        this.path.clear();
    }

    public Point2D getFinalDestination() {
        return this.finalDestination;
    }

    public Point2D getCurrentDestination() {
        return this.currentDestination;
    }

    public PathElement getCurrentElement() {
        return this.currentPathElement;
    }

    public List<PathElement> getPath() {
        return Collections.unmodifiableList((List)((Object)this.path));
    }

    public void setLocation(double x, double y) {
        double dy;
        if (this.currentArea == null || !this.currentArea.contains(x, y)) {
            TrafficArea newArea;
            if (this.currentArea != null) {
                this.currentArea.removeAgent(this);
            }
            if ((newArea = this.manager.findArea(x, y)) == null) {
                Logger.warn((String)("Agent moved outside area: " + this));
                return;
            }
            this.currentArea = newArea;
            this.findBlockingLines();
            this.currentArea.addAgent(this);
        }
        if (this.currentPathElement != null && this.currentDestination == this.currentPathElement.getGoal() && this.currentDestination != this.finalDestination) {
            if (this.currentPathElement.getEdgeLine() != null && this.crossedLine(this.location[0], this.location[1], x, y, this.currentPathElement.getEdgeLine())) {
                this.currentPathElement = null;
            } else {
                double dx = x - this.currentDestination.getX();
                double distanceSquared = dx * dx + (dy = y - this.currentDestination.getY()) * dy;
                if (distanceSquared < 1000000.0) {
                    this.currentPathElement = null;
                }
            }
        }
        if (this.savePositionHistory) {
            if (this.historyCount % this.positionHistoryFrequency == 0) {
                this.positionHistory.add(new Point2D(x, y));
            }
            ++this.historyCount;
            double dx = x - this.location[0];
            dy = y - this.location[1];
            this.totalDistance += Math.hypot(dx, dy);
        }
        this.location[0] = x;
        this.location[1] = y;
    }

    public void beginTimestep() {
        this.findBlockingLines();
        if (this.insideBlockade()) {
            Logger.debug((String)(this + " inside blockade"));
            this.setMobile(false);
        }
    }

    public void step(double dt) {
        if (this.mobile) {
            this.updateWalls(dt);
            this.updateGoals();
            this.computeForces(dt);
            this.updatePosition(dt);
        }
    }

    public void endTimestep() {
    }

    public void setMobile(boolean m) {
        this.mobile = m;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
        Logger.debug((String)(this + " is now " + (this.verbose ? "" : "not ") + "verbose"));
    }

    private void updateGoals() {
        if (this.currentPathElement == null) {
            if (this.path.isEmpty()) {
                this.currentDestination = this.finalDestination;
                this.currentPathElement = null;
            } else {
                this.currentPathElement = this.path.remove();
                if (this.verbose) {
                    Logger.debug((String)(this + " updated path: " + this.path));
                }
            }
        }
        if (this.currentPathElement != null) {
            this.currentDestination = this.currentPathElement.getGoal();
            Point2D current = new Point2D(this.location[0], this.location[1]);
            Vector2D vectorToEdge = this.currentDestination.minus(current).normalised();
            if (this.verbose) {
                Logger.debug((String)(this + " finding goal point"));
                Logger.debug((String)(this + " current path element: " + this.currentPathElement));
                Logger.debug((String)(this + " current position: " + current));
                Logger.debug((String)(this + " edge goal: " + this.currentDestination));
            }
            for (Point2D next : this.currentPathElement.getWaypoints()) {
                Vector2D vectorToNext;
                double dot;
                if (this.verbose) {
                    Logger.debug((String)(this + " next possible goal: " + next));
                }
                if (next != this.currentPathElement.getGoal() && ((dot = (vectorToNext = next.minus(current).normalised()).dot(vectorToEdge)) < 0.0 || dot > 1.0)) {
                    if (!this.verbose) continue;
                    Logger.debug((String)("Dot product of " + vectorToNext + " and " + vectorToEdge + " is " + dot));
                    Logger.debug((String)(this + " next point is " + (dot < 0.0 ? "backwards" : "too distant") + "; ignoring"));
                    continue;
                }
                if (!this.hasLos(current, next, this.currentArea)) continue;
                this.currentDestination = next;
                if (!this.verbose) break;
                Logger.debug((String)(this + " has line-of-sight to " + next));
                break;
            }
        }
    }

    private void computeForces(double dt) {
        this.colocated = false;
        this.computeAgentsForce(this.agentsForce);
        if (!this.colocated) {
            this.computeDestinationForce(this.destinationForce);
            this.computeWallsForce(this.wallsForce, dt);
        }
        this.force[0] = this.destinationForce[0] + this.agentsForce[0] + this.wallsForce[0];
        this.force[1] = this.destinationForce[1] + this.agentsForce[1] + this.wallsForce[1];
        if (Double.isNaN(this.force[0]) || Double.isNaN(this.force[1])) {
            Logger.warn((String)"Force is NaN!");
            this.force[0] = 0.0;
            this.force[1] = 0.0;
        }
    }

    private void updatePosition(double dt) {
        double newVX = this.velocity[0] + dt * this.force[0];
        double newVY = this.velocity[1] + dt * this.force[1];
        double v = Math.hypot(newVX, newVY);
        if (v > this.velocityLimit) {
            newVX /= (v /= this.velocityLimit);
            newVY /= v;
        }
        double x = this.location[0] + dt * newVX;
        double y = this.location[1] + dt * newVY;
        if (this.verbose) {
            Logger.debug((String)("Updating position for " + this));
            Logger.debug((String)("Current position   : " + this.location[0] + ", " + this.location[1]));
            Logger.debug((String)("Current velocity   : " + this.velocity[0] + ", " + this.velocity[1]));
            Logger.debug((String)("Destination forces : " + this.destinationForce[0] + ", " + this.destinationForce[1]));
            Logger.debug((String)("Agent forces       : " + this.agentsForce[0] + ", " + this.agentsForce[1]));
            Logger.debug((String)("Wall forces        : " + this.wallsForce[0] + ", " + this.wallsForce[1]));
            Logger.debug((String)("Total forces       : " + this.force[0] + ", " + this.force[1]));
            Logger.debug((String)("New position       : " + x + ", " + y));
            Logger.debug((String)("New velocity       : " + newVX + ", " + newVY));
        }
        if (this.crossedWall(this.location[0], this.location[1], x, y)) {
            this.velocity[0] = 0.0;
            this.velocity[1] = 0.0;
            return;
        }
        this.velocity[0] = newVX;
        this.velocity[1] = newVY;
        if (newVX != 0.0 || newVY != 0.0) {
            double dist = v * dt;
            for (WallInfo wall : this.blockingLines) {
                wall.decreaseDistance(dist);
            }
            this.setLocation(x, y);
        }
    }

    private boolean hasLos(WallInfo target, List<WallInfo> blocking) {
        Line2D line = target.getLine();
        for (WallInfo wall : blocking) {
            double dotp;
            if (wall == target) break;
            Line2D next = wall.getWall();
            if (target.getClosestPoint().equals((Object)next.getOrigin()) || target.getClosestPoint().equals((Object)next.getEndPoint()) || (dotp = line.getDirection().dot(wall.getVector())) < wall.getDistance() * wall.getDistance() || GeometryTools2D.getSegmentIntersectionPoint((Line2D)line, (Line2D)next) == null) continue;
            return false;
        }
        return true;
    }

    private boolean hasLos(Point2D source, Point2D target, TrafficArea area) {
        Line2D line = new Line2D(source, target);
        double dist = line.getDirection().getLength();
        for (WallInfo wall : this.blockingLines) {
            if (wall.getDistance() > dist || wall.getArea() != area) break;
            Line2D next = wall.getWall();
            if (GeometryTools2D.getSegmentIntersectionPoint((Line2D)line, (Line2D)next) == null) continue;
            return false;
        }
        return true;
    }

    private boolean insideBlockade() {
        if (this.currentArea == null) {
            return false;
        }
        for (TrafficBlockade block : this.currentArea.getBlockades()) {
            if (!block.contains(this.location[0], this.location[1])) continue;
            return true;
        }
        return false;
    }

    private boolean crossedLine(double oldX, double oldY, double newX, double newY, Line2D line) {
        Line2D moved = new Line2D(oldX, oldY, newX - oldX, newY - oldY);
        return GeometryTools2D.getSegmentIntersectionPoint((Line2D)moved, (Line2D)line) != null;
    }

    private boolean crossedWall(double oldX, double oldY, double newX, double newY) {
        Line2D moved = new Line2D(oldX, oldY, newX - oldX, newY - oldY);
        double dist = moved.getDirection().getLength();
        for (WallInfo wall : this.blockingLines) {
            if (wall.getDistance() >= dist) break;
            Line2D test = wall.getWall();
            if (GeometryTools2D.getSegmentIntersectionPoint((Line2D)moved, (Line2D)test) == null) continue;
            return true;
        }
        return false;
    }

    private void findBlockingLines() {
        this.blockingLines.clear();
        if (this.currentArea != null) {
            for (Line2D line : this.currentArea.getAllBlockingLines()) {
                this.blockingLines.add(new WallInfo(line, this.currentArea));
            }
            for (TrafficArea neighbour : this.manager.getNeighbours(this.currentArea)) {
                for (Line2D line : neighbour.getAllBlockingLines()) {
                    this.blockingLines.add(new WallInfo(line, neighbour));
                }
            }
        }
    }

    private void updateWalls(double dt) {
        Point2D position = new Point2D(this.location[0], this.location[1]);
        double crossingCutoff = dt * this.velocityLimit;
        double forceCutoff = TrafficConstants.getWallDistanceCutoff();
        double cutoff = Math.max(forceCutoff, crossingCutoff);
        for (WallInfo wall : this.blockingLines) {
            if (wall.getDistance() > cutoff) continue;
            wall.computeClostestPoint(position);
        }
        block1: for (int i = 1; i < this.blockingLines.size(); ++i) {
            WallInfo info = this.blockingLines.get(i);
            for (int j = i; j >= 0; --j) {
                if (j == 0) {
                    this.blockingLines.remove(i);
                    this.blockingLines.add(0, info);
                    continue;
                }
                if (!(this.blockingLines.get(j - 1).getDistance() < info.getDistance())) continue;
                if (j == i) continue block1;
                this.blockingLines.remove(i);
                this.blockingLines.add(j, info);
                continue block1;
            }
        }
    }

    private void computeDestinationForce(double[] result) {
        double destx = 0.0;
        double desty = 0.0;
        if (this.currentDestination != null) {
            double dy;
            double dx = this.currentDestination.getX() - this.location[0];
            double dist = Math.hypot(dx, dy = this.currentDestination.getY() - this.location[1]);
            if (dist == 0.0) {
                dx = 0.0;
                dy = 0.0;
            } else {
                dx /= dist;
                dy /= dist;
            }
            double ddd = 0.001;
            if (this.currentDestination == this.finalDestination) {
                dx = Math.min(this.velocityLimit, 0.001 * dist) * dx;
                dy = Math.min(this.velocityLimit, 0.001 * dist) * dy;
            } else {
                dx = this.velocityLimit * dx;
                dy = this.velocityLimit * dy;
            }
            double sss2 = 2.0E-4;
            destx = 2.0E-4 * (dx - this.velocity[0]);
            desty = 2.0E-4 * (dy - this.velocity[1]);
        } else {
            double sss = 1.0E-4;
            destx = 1.0E-4 * -this.velocity[0];
            desty = 1.0E-4 * -this.velocity[1];
        }
        result[0] = destx;
        result[1] = desty;
        if (Double.isNaN(destx)) {
            Logger.error((String)"Destination force x is NaN");
            result[0] = 0.0;
        }
        if (Double.isNaN(desty)) {
            Logger.error((String)"Destination force y is NaN");
            result[1] = 0.0;
        }
        if (this.verbose) {
            Logger.debug((String)("Destination force: " + result[0] + ", " + result[1]));
        }
    }

    private void computeAgentsForce(double[] result) {
        double forceSum;
        result[0] = 0.0;
        result[1] = 0.0;
        if (this.currentArea == null) {
            return;
        }
        double xSum = 0.0;
        double ySum = 0.0;
        double cutoff = TrafficConstants.getAgentDistanceCutoff();
        double a = TrafficConstants.getAgentForceCoefficientA();
        double b = TrafficConstants.getAgentForceCoefficientB();
        double k = TrafficConstants.getAgentForceCoefficientK();
        double forceLimit = TrafficConstants.getAgentForceLimit();
        Collection<TrafficAgent> nearby = this.manager.getNearbyAgents(this);
        for (TrafficAgent agent : nearby) {
            if (!agent.isMobile()) continue;
            double dx = agent.getX() - this.location[0];
            double dy = agent.getY() - this.location[1];
            if (Math.abs(dx) > cutoff || Math.abs(dy) > cutoff) continue;
            double totalRadius = this.radius + agent.getRadius();
            double distanceSquared = dx * dx + dy * dy;
            if (distanceSquared == 0.0) {
                xSum = TrafficConstants.getColocatedAgentNudge();
                ySum = TrafficConstants.getColocatedAgentNudge();
                this.colocated = true;
                Logger.debug((String)(this + " is co-located with " + agent));
                break;
            }
            double distance = Math.sqrt(distanceSquared);
            double dxN = dx / distance;
            double dyN = dy / distance;
            double negativeSeparation = totalRadius - distance;
            double tmp = -a * Math.exp(negativeSeparation * b);
            if (Double.isInfinite(tmp)) {
                Logger.warn((String)("calculateAgentsForce(): A result of exp is infinite: exp(" + negativeSeparation * b + ")"));
            } else {
                xSum += tmp * dxN;
                ySum += tmp * dyN;
            }
            if (!(negativeSeparation > 0.0)) continue;
            xSum += -k * negativeSeparation * dxN;
            ySum += -k * negativeSeparation * dyN;
        }
        if ((forceSum = Math.hypot(xSum, ySum)) > forceLimit) {
            xSum /= (forceSum /= forceLimit);
            ySum /= forceSum;
        }
        if (Double.isNaN(xSum)) {
            Logger.warn((String)"computeAgentsForce: Sum of X force is NaN");
            xSum = 0.0;
        }
        if (Double.isNaN(ySum)) {
            Logger.warn((String)"computeAgentsForce: Sum of Y force is NaN");
            ySum = 0.0;
        }
        result[0] = xSum;
        result[1] = ySum;
    }

    private void computeWallsForce(double[] result, double dt) {
        double xSum = 0.0;
        double ySum = 0.0;
        if (this.currentArea != null) {
            double r = this.getRadius();
            double cutoff = TrafficConstants.getWallDistanceCutoff();
            double b = TrafficConstants.getWallForceCoefficientB();
            Point2D position = new Point2D(this.location[0], this.location[1]);
            if (this.verbose) {
                Logger.debug((String)("Computing wall forces for " + this));
                Logger.debug((String)("Position: " + position));
            }
            for (WallInfo wall : this.blockingLines) {
                if (wall.getDistance() > cutoff) break;
                Line2D line = wall.getWall();
                double dist = wall.getDistance();
                Point2D closest = wall.getClosestPoint();
                if (this.verbose) {
                    Logger.debug((String)("Next wall: " + line));
                }
                if (this.verbose) {
                    Logger.debug((String)("Closest point: " + closest));
                }
                if (!this.hasLos(wall, this.blockingLines)) {
                    if (!this.verbose) continue;
                    Logger.debug((String)"No line of sight");
                    continue;
                }
                boolean endPoint = false;
                if (closest == line.getOrigin() || closest == line.getEndPoint()) {
                    endPoint = true;
                }
                double currentVX = this.velocity[0];
                double currentVY = this.velocity[1];
                double currentFX = this.destinationForce[0] + this.agentsForce[0];
                double currentFY = this.destinationForce[1] + this.agentsForce[1];
                double expectedVX = currentVX + dt * currentFX;
                double expectedVY = currentVY + dt * currentFY;
                Vector2D expectedVelocity = new Vector2D(expectedVX, expectedVY);
                Vector2D wallForceVector = wall.getVector().scale(-1.0 / dist);
                double radii = dist / r;
                double magnitude = -expectedVelocity.dot(wallForceVector);
                if (magnitude < 0.0 || radii >= 1.0) {
                    magnitude = 0.0;
                } else if (radii < 1.0) {
                    double d = Math.exp(-(radii - 1.0) * b);
                    if (d < 1.0) {
                        d = 0.0;
                    }
                    magnitude *= d;
                    if (endPoint) {
                        magnitude /= 2.0;
                    }
                }
                Vector2D stopForce = wallForceVector.scale(magnitude / dt);
                xSum += stopForce.getX();
                ySum += stopForce.getY();
                if (!this.verbose) continue;
                Logger.debug((String)("Distance to wall : " + dist));
                Logger.debug((String)("Distance to wall : " + radii + " radii"));
                Logger.debug((String)("Current velocity : " + currentVX + ", " + currentVY));
                Logger.debug((String)("Current force    : " + currentFX + ", " + currentFY));
                Logger.debug((String)("Expected velocity: " + expectedVelocity));
                Logger.debug((String)("Wall force       : " + wallForceVector));
                Logger.debug((String)("Magnitude        : " + magnitude));
                Logger.debug((String)("Stop force       : " + stopForce));
            }
        }
        if (Double.isNaN(xSum) || Double.isNaN(ySum)) {
            xSum = 0.0;
            ySum = 0.0;
        }
        if (this.verbose) {
            Logger.debug((String)("Total wall force: " + xSum + ", " + ySum));
        }
        result[0] = xSum;
        result[1] = ySum;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TrafficAgent[");
        sb.append("id:").append(this.human.getID()).append(";");
        sb.append("x:").append((int)this.getX()).append(";");
        sb.append("y:").append((int)this.getY()).append(";");
        sb.append("]");
        return sb.toString();
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer("TrafficAgent[");
        sb.append("id: ").append(this.human.getID()).append(";");
        sb.append(" x: ").append(this.location[0]).append(";");
        sb.append(" y: ").append(this.location[1]).append(";");
        sb.append(" current area: ").append(this.currentArea).append(";");
        sb.append(" current destination: ").append(this.currentDestination).append(";");
        sb.append(" final destination: ").append(this.finalDestination).append(";");
        sb.append("]");
        return sb.toString();
    }

    private static class WallInfo {
        private Line2D wall;
        private TrafficArea area;
        private double distance;
        private Point2D closest;
        private Point2D origin;
        private Line2D line;
        private Vector2D vector;

        public WallInfo(Line2D wall, TrafficArea area) {
            this.wall = wall;
            this.area = area;
            this.distance = -1.0;
            this.closest = null;
            this.origin = null;
        }

        public double getDistance() {
            return this.distance;
        }

        public void computeClostestPoint(Point2D from) {
            if (from.equals((Object)this.origin) && this.distance >= 0.0 && this.closest != null) {
                return;
            }
            this.origin = from;
            this.closest = GeometryTools2D.getClosestPointOnSegment((Line2D)this.wall, (Point2D)this.origin);
            this.line = new Line2D(this.origin, this.closest);
            this.vector = this.line.getDirection();
            this.distance = this.vector.getLength();
        }

        public Point2D getClosestPoint() {
            return this.closest;
        }

        public void decreaseDistance(double d) {
            this.distance -= d;
        }

        public Line2D getWall() {
            return this.wall;
        }

        public Line2D getLine() {
            return this.line;
        }

        public Vector2D getVector() {
            return this.vector;
        }

        public TrafficArea getArea() {
            return this.area;
        }
    }
}

