/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.sample;

import rescuecore.CenterAgent;
import rescuecore.Handy;
import rescuecore.RescueObject;
import rescuecore.commands.AKChannel;
import rescuecore.objects.Building;

public class SampleCenter
extends CenterAgent {
    private byte agentChannel = 0;

    public SampleCenter() {
        super(34, 35, 36);
    }

    private Building me() {
        return (Building)this.memory.lookup(this.id);
    }

    @Override
    public void initialise(RescueObject[] knowledge) {
        super.initialise(knowledge);
        switch (this.type) {
            case 34: {
                this.agentChannel = 1;
                break;
            }
            case 36: {
                this.agentChannel = (byte)2;
                break;
            }
            case 35: {
                this.agentChannel = (byte)3;
            }
        }
    }

    @Override
    public void sense() {
        if (this.timeStep == 1) {
            byte[] channels = new byte[]{4, this.agentChannel};
            this.appendCommand(new AKChannel(this.id, this.timeStep, channels));
        }
    }

    @Override
    protected void hear(int from, byte[] msg, byte channel) {
        if (channel == 4) {
            this.tell(msg, this.agentChannel);
        }
        if (channel == this.agentChannel) {
            this.tell(msg, (byte)4);
        }
    }

    private boolean isPlatoon(int id) {
        int agentType = this.memory.lookup(id).getType();
        switch (this.type) {
            case 34: {
                return agentType == 66;
            }
            case 36: {
                return agentType == 68;
            }
            case 35: {
                return agentType == 67;
            }
        }
        throw new RuntimeException("Weird type for " + this + ": " + Handy.getTypeName(this.type));
    }

    private boolean isCenter(int id) {
        RescueObject target = this.memory.lookup(id);
        return target.isFireStation() || target.isAmbulanceCenter() || target.isPoliceOffice();
    }
}

