/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import rescuecore.PlatoonAgent;
import rescuecore.RescueObject;
import rescuecore.commands.AKChannel;
import rescuecore.event.MemoryListener;
import rescuecore.event.ObjectAddedEvent;
import rescuecore.event.ObjectChangedEvent;
import rescuecore.objects.AmbulanceTeam;
import rescuecore.objects.Humanoid;
import rescuecore.objects.Refuge;
import rescuecore.objects.Road;
import rescuecore.sample.SampleSearch;

public class SampleAmbulanceTeam
extends PlatoonAgent {
    private static final byte CHANNEL = 3;
    private List<Humanoid> targets = new ArrayList<Humanoid>();

    public SampleAmbulanceTeam() {
        super(67);
    }

    private AmbulanceTeam me() {
        return (AmbulanceTeam)this.memory.lookup(this.id);
    }

    @Override
    public void initialise(RescueObject[] knowledge) {
        super.initialise(knowledge);
        this.memory.addMemoryListener(new MemoryListener(){

            @Override
            public void objectAdded(ObjectAddedEvent event) {
                Humanoid h;
                RescueObject o = event.getObject();
                if (o.isHumanoid() && ((h = (Humanoid)o).isBuried() || h.isDamaged()) && SampleAmbulanceTeam.this.memory.lookup(h.getPosition()) != null && !SampleAmbulanceTeam.this.targets.contains(h)) {
                    SampleAmbulanceTeam.this.targets.add(h);
                }
            }

            @Override
            public void objectChanged(ObjectChangedEvent event) {
                RescueObject o = event.getObject();
                if (o.isHumanoid()) {
                    Humanoid h = (Humanoid)o;
                    if ((h.isBuried() || h.isDamaged()) && SampleAmbulanceTeam.this.memory.lookup(h.getPosition()) != null) {
                        if (!SampleAmbulanceTeam.this.targets.contains(h)) {
                            SampleAmbulanceTeam.this.targets.add(h);
                        }
                    } else {
                        SampleAmbulanceTeam.this.targets.remove(h);
                    }
                }
            }
        });
    }

    @Override
    public void sense() {
        int[] path;
        if (this.timeStep == 1) {
            this.appendCommand(new AKChannel(this.id, this.timeStep, 3));
        }
        SampleSearch.sortByDistance(this.targets, (RescueObject)this.me(), this.memory);
        for (Humanoid next : this.targets) {
            if (next == this.me()) continue;
            if (next.getPosition() == this.id) {
                if (this.getLocation() instanceof Refuge) {
                    this.unload();
                    this.tell("Unloading".getBytes(), (byte)3);
                    return;
                }
                ArrayList<RescueObject> refuges = new ArrayList<RescueObject>();
                this.memory.getObjectsOfType(refuges, 33);
                SampleSearch.sortByDistance(refuges, (RescueObject)this.me(), this.memory);
                int[] path2 = SampleSearch.breadthFirstSearch(this.getLocation(), (RescueObject)refuges.iterator().next(), this.memory);
                this.move(path2);
                return;
            }
            if (this.getLocation() instanceof Refuge || next.getPosition() != this.getPosition()) continue;
            if (next.isBuried()) {
                this.rescue(next);
                this.tell(("Rescueing " + next.getID()).getBytes(), (byte)3);
                return;
            }
            if (!next.isDamaged()) continue;
            System.out.println(this + " loading " + next);
            this.load(next);
            this.tell(("Loading " + next.getID()).getBytes(), (byte)3);
            return;
        }
        Iterator<Humanoid> it = this.targets.iterator();
        while (it.hasNext()) {
            Humanoid next;
            next = it.next();
            RescueObject targetLocation = this.memory.lookup(next.getPosition());
            if (!next.isBuried() || targetLocation == null) {
                it.remove();
                continue;
            }
            path = SampleSearch.breadthFirstSearch(this.getLocation(), targetLocation, this.memory);
            if (path == null) continue;
            this.move(path);
            return;
        }
        Collection<RescueObject> allRoads = this.memory.getObjectsOfType(2);
        Road[] roads = new Road[allRoads.size()];
        allRoads.toArray(roads);
        Road target = roads[(int)(Math.random() * (double)roads.length)];
        path = SampleSearch.breadthFirstSearch(this.getLocation(), target, this.memory);
        if (path != null) {
            this.move(path);
        }
    }

    @Override
    protected void hear(int from, byte[] msg, byte channel) {
    }
}

