/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.ArrayProperty;
import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.MotionlessObject;

public abstract class Vertex
extends MotionlessObject {
    protected IntProperty x;
    protected IntProperty y;
    protected ArrayProperty edges;

    protected Vertex() {
        this.x = new IntProperty(25);
        this.y = new IntProperty(26);
        this.edges = new ArrayProperty(27);
    }

    protected Vertex(int x, int y, int[] edges) {
        this.x = new IntProperty(25, x);
        this.y = new IntProperty(26, y);
        this.edges = new ArrayProperty(27, edges);
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 25: {
                return this.x;
            }
            case 26: {
                return this.y;
            }
            case 27: {
                return this.edges;
            }
        }
        return super.getProperty(property);
    }

    public int getX() {
        return this.x.getValue();
    }

    public boolean setX(int newX, int timestamp, Object source) {
        if (this.x.updateValue(newX, timestamp, source)) {
            this.firePropertyChanged(25, timestamp, source);
            return true;
        }
        return false;
    }

    public int getY() {
        return this.y.getValue();
    }

    public boolean setY(int newY, int timestamp, Object source) {
        if (this.y.updateValue(newY, timestamp, source)) {
            this.firePropertyChanged(26, timestamp, source);
            return true;
        }
        return false;
    }

    public int[] getEdges() {
        return this.edges.getValues();
    }

    public boolean setEdges(int[] newEdges, int timestamp, Object source) {
        if (this.edges.updateValues(newEdges, timestamp, source)) {
            this.firePropertyChanged(27, timestamp, source);
            return true;
        }
        return false;
    }

    public void appendEdge(int next, int timestamp, Object source) {
        this.edges.append(next);
        this.firePropertyChanged(27, timestamp, source);
    }

    public void clearEdges(int timestamp, Object source) {
        this.edges.clear();
        this.firePropertyChanged(27, timestamp, source);
    }
}

