/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.RescueConstants;
import rescuecore.RescueObject;
import rescuecore.commands.Command;

public class Update
extends Command {
    private int time;
    private RescueObject[] changed;

    public Update(int time, RescueObject[] changed) {
        super(80);
        this.time = time;
        this.changed = changed;
    }

    public Update(InputBuffer in) {
        super(80);
        this.read(in);
    }

    @Override
    public void read(InputBuffer in) {
        this.time = in.readInt();
        this.changed = in.readObjects(this.time, RescueConstants.SOURCE_UPDATE);
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.time);
        out.writeObjects(this.changed);
    }

    public int getTime() {
        return this.time;
    }

    public RescueObject[] getUpdatedObjects() {
        return this.changed;
    }
}

