/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.Handy;
import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.Command;

public abstract class AgentCommand
extends Command {
    protected int senderID;
    protected int time;

    protected AgentCommand(int type, int senderID, int time) {
        super(type);
        this.senderID = senderID;
        this.time = time;
    }

    public final int getSender() {
        return this.senderID;
    }

    public final int getTime() {
        return this.time;
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.senderID);
        out.writeInt(this.time);
    }

    @Override
    public void read(InputBuffer in) {
        this.senderID = in.readInt();
        this.time = in.readInt();
    }

    @Override
    public String toString() {
        return Handy.getCommandTypeName(this.type) + " from agent " + this.senderID + " at time " + this.time;
    }
}

