/*
 * Decompiled with CFR 0.152.
 */
package kernel.ui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kernel.ComponentManager;
import kernel.InlineComponentLauncher;
import kernel.Kernel;
import kernel.KernelException;
import rescuecore2.components.Component;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.ComponentInitialisationException;
import rescuecore2.components.ComponentLauncher;
import rescuecore2.config.Config;
import rescuecore2.config.NoSuchConfigOptionException;
import rescuecore2.connection.ConnectionException;
import rescuecore2.log.LogException;
import rescuecore2.log.Logger;
import rescuecore2.misc.WorkerThread;
import rescuecore2.misc.java.JavaTools;
import rescuecore2.registry.Registry;

public class KernelControlPanel
extends JPanel {
    private Kernel kernel;
    private Config config;
    private Registry registry;
    private ComponentManager componentManager;
    private ComponentLauncher launcher;
    private Collection<JButton> controlButtons;
    private JButton stepButton;
    private JButton runButton;
    private volatile boolean running;
    private volatile boolean step;
    private RunThread runThread;
    private final Object runLock = new Object();

    public KernelControlPanel(Kernel kernel, Config config, ComponentManager componentManager, Registry registry) {
        super(new GridLayout(0, 1));
        this.kernel = kernel;
        this.config = config;
        this.componentManager = componentManager;
        this.registry = registry;
        this.controlButtons = new ArrayList<JButton>();
        JButton addAgent = new JButton("Add agent");
        JButton removeAgent = new JButton("Remove agent");
        JButton addSim = new JButton("Add simulator");
        JButton removeSim = new JButton("Remove simulator");
        JButton addViewer = new JButton("Add viewer");
        JButton removeViewer = new JButton("Remove viewer");
        this.stepButton = new JButton("Step");
        this.runButton = new JButton("Run");
        this.add(addAgent);
        this.add(removeAgent);
        this.add(addSim);
        this.add(removeSim);
        this.add(addViewer);
        this.add(removeViewer);
        this.add(this.stepButton);
        this.add(this.runButton);
        this.controlButtons.add(addAgent);
        this.controlButtons.add(removeAgent);
        this.controlButtons.add(addSim);
        this.controlButtons.add(removeSim);
        this.controlButtons.add(addViewer);
        this.controlButtons.add(removeViewer);
        addAgent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.addAgent();
            }
        });
        removeAgent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.removeAgent();
            }
        });
        addSim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.addSim();
            }
        });
        removeSim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.removeSim();
            }
        });
        addViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.addViewer();
            }
        });
        removeViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.removeViewer();
            }
        });
        this.stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.stepButtonPressed();
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KernelControlPanel.this.runButtonPressed();
            }
        });
        this.runThread = new RunThread();
        this.running = false;
    }

    public void activate() {
        this.runThread.start();
        this.launcher = new InlineComponentLauncher(this.componentManager, this.config);
        this.launcher.setDefaultRegistry(Registry.getCurrentRegistry());
    }

    private void addAgent() {
        Component[] as = this.createComponents("agents");
        this.addComponent(as, "agent");
    }

    private void removeAgent() {
    }

    private void addSim() {
        Component[] ss = this.createComponents("simulators");
        this.addComponent(ss, "simulator");
    }

    private void removeSim() {
    }

    private void addViewer() {
        Component[] vs = this.createComponents("viewers");
        this.addComponent(vs, "viewer");
    }

    private void removeViewer() {
    }

    private void addComponent(Component[] options, String type) {
        if (options.length == 0) {
            return;
        }
        Component c = (Component)JOptionPane.showInputDialog(this, "Choose a " + type, "Choose a " + type, 3, null, options, options[0]);
        if (c == null) {
            return;
        }
        try {
            c.initialise();
            this.launcher.connect(c);
        }
        catch (NoSuchConfigOptionException e) {
            JOptionPane.showMessageDialog(this, "Adding " + type + " failed: " + (Object)((Object)e));
        }
        catch (ComponentInitialisationException e) {
            JOptionPane.showMessageDialog(this, "Adding " + type + " failed: " + (Object)((Object)e));
        }
        catch (ComponentConnectionException e) {
            JOptionPane.showMessageDialog(this, "Adding " + type + " failed: " + e.getMessage());
        }
        catch (ConnectionException e) {
            JOptionPane.showMessageDialog(this, "Adding " + type + " failed: " + (Object)((Object)e));
        }
        catch (InterruptedException e) {
            JOptionPane.showMessageDialog(this, "Adding " + type + " failed: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stepButtonPressed() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("stepButtonPressed called by thread " + Thread.currentThread() + ", not the event dispatch thread.");
        }
        Object object = this.runLock;
        synchronized (object) {
            if (!this.running) {
                this.step = true;
                this.stepButton.setText("Working");
                this.stepButton.setEnabled(false);
                this.runButton.setEnabled(false);
                this.setControlButtonsEnabled(false);
                this.runLock.notifyAll();
            }
        }
    }

    private void endStep() {
        this.step = false;
        this.stepButton.setText("Step");
        this.stepButton.setEnabled(true);
        this.runButton.setEnabled(true);
        this.setControlButtonsEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runButtonPressed() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("runButtonPressed called by thread " + Thread.currentThread() + ", not the event dispatch thread.");
        }
        Object object = this.runLock;
        synchronized (object) {
            if (this.running) {
                this.setControlButtonsEnabled(true);
                this.stepButton.setEnabled(true);
                this.runButton.setText("Run");
            } else {
                this.setControlButtonsEnabled(false);
                this.stepButton.setEnabled(false);
                this.runButton.setText("Stop");
            }
            this.running = !this.running;
            this.runLock.notifyAll();
        }
    }

    private void setControlButtonsEnabled(boolean b) {
        for (JButton next : this.controlButtons) {
            next.setEnabled(b);
        }
    }

    private void disableAllButtons() throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    KernelControlPanel.this.setControlButtonsEnabled(false);
                    KernelControlPanel.this.stepButton.setEnabled(false);
                    KernelControlPanel.this.runButton.setEnabled(false);
                }
            });
        }
        catch (InvocationTargetException e) {
            Logger.error((String)"KernelControlPanel.disableAllButtons", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldStep() {
        Object object = this.runLock;
        synchronized (object) {
            return this.running || this.step;
        }
    }

    private Component[] createComponents(String type) {
        List classNames = this.config.getArrayValue("kernel." + type, null);
        ArrayList<Component> instances = new ArrayList<Component>();
        for (String next : classNames) {
            Component c = (Component)JavaTools.instantiate((String)next, Component.class);
            if (c == null) continue;
            instances.add(c);
        }
        return instances.toArray(new Component[0]);
    }

    private class RunThread
    extends WorkerThread {
        private RunThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean work() throws InterruptedException {
            if (KernelControlPanel.this.shouldStep()) {
                if (!KernelControlPanel.this.kernel.hasTerminated()) {
                    try {
                        KernelControlPanel.this.kernel.timestep();
                    }
                    catch (KernelException e) {
                        Logger.error((String)"Kernel error", (Throwable)e);
                        KernelControlPanel.this.kernel.shutdown();
                        KernelControlPanel.this.disableAllButtons();
                        return false;
                    }
                    catch (LogException e) {
                        Logger.error((String)"Log error", (Throwable)e);
                        KernelControlPanel.this.kernel.shutdown();
                        KernelControlPanel.this.disableAllButtons();
                        return false;
                    }
                    Object object = KernelControlPanel.this.runLock;
                    synchronized (object) {
                        if (KernelControlPanel.this.step) {
                            KernelControlPanel.this.endStep();
                        }
                    }
                    return true;
                }
                KernelControlPanel.this.kernel.shutdown();
                KernelControlPanel.this.disableAllButtons();
                return false;
            }
            Object object = KernelControlPanel.this.runLock;
            synchronized (object) {
                KernelControlPanel.this.runLock.wait(1000L);
            }
            return true;
        }
    }
}

