/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.ArrayList;
import java.util.Collection;
import kernel.AgentProxy;
import kernel.CommandCollector;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;

public class TimedCommandCollector
implements CommandCollector {
    private static final int DEFAULT_TIME = 1000;
    private static final String TIME_KEY = "kernel.agents.think-time";
    private long time;

    @Override
    public void initialise(Config config) {
        this.time = config.getIntValue(TIME_KEY, 1000);
    }

    @Override
    public Collection<Command> getAgentCommands(Collection<AgentProxy> agents, int timestep) throws InterruptedException {
        long now = System.currentTimeMillis();
        long end = now + this.time;
        while (now < end) {
            long diff = end - now;
            Logger.trace((String)(this + " waiting for " + diff + "ms"));
            Thread.sleep(diff);
            now = System.currentTimeMillis();
        }
        ArrayList<Command> result = new ArrayList<Command>();
        for (AgentProxy next : agents) {
            Collection<Command> commands = next.getAgentCommands(timestep);
            result.addAll(commands);
        }
        Logger.trace((String)(this + " returning " + result.size() + " commands"));
        Logger.trace((String)(this + " returning " + result));
        return result;
    }

    public String toString() {
        return "Timed command collector";
    }
}

