/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kernel.AbstractKernelComponent;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.KASense;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;

public class AgentProxy
extends AbstractKernelComponent {
    private Entity entity;
    private Map<Integer, Collection<Command>> commands;

    public AgentProxy(String name, Entity e, Connection c) {
        super(name, c);
        this.entity = e;
        this.commands = new LazyMap<Integer, Collection<Command>>(){

            public Collection<Command> createValue() {
                return new ArrayList<Command>();
            }
        };
        c.addConnectionListener((ConnectionListener)new AgentConnectionListener());
    }

    public String toString() {
        return this.getName() + ": " + this.entity.getURN() + " " + this.entity.getID();
    }

    public Entity getControlledEntity() {
        return this.entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Command> getAgentCommands(int timestep) {
        Collection<Command> result;
        Map<Integer, Collection<Command>> map = this.commands;
        synchronized (map) {
            result = this.commands.get(timestep);
        }
        Logger.trace((String)(this.entity.toString() + " getAgentCommands(" + timestep + ") returning " + result));
        return result;
    }

    public void sendPerceptionUpdate(int time, ChangeSet visible, Collection<? extends Command> heard) {
        KASense sense = new KASense(this.getControlledEntity().getID(), time, visible, heard);
        this.send((Message)sense);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandReceived(Command c) {
        if (!c.getAgentID().equals((Object)this.entity.getID())) {
            Logger.warn((String)("Ignoring bogus command: Agent " + this.entity.getID() + " tried to send a command for agent " + c.getAgentID()));
            return;
        }
        int time = c.getTime();
        Logger.trace((String)("AgentProxy " + this.entity + " received " + c));
        Map<Integer, Collection<Command>> map = this.commands;
        synchronized (map) {
            Collection<Command> result = this.commands.get(time);
            result.add(c);
            this.commands.notifyAll();
        }
    }

    private class AgentConnectionListener
    implements ConnectionListener {
        private AgentConnectionListener() {
        }

        public void messageReceived(Connection c, Message msg) {
            EntityID id;
            if (msg instanceof Command && (id = ((Command)msg).getAgentID()).equals((Object)AgentProxy.this.getControlledEntity().getID())) {
                AgentProxy.this.commandReceived((Command)msg);
            }
        }
    }
}

