/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import java.util.EnumSet;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.StandardEntityConstants;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.properties.BooleanProperty;
import rescuecore2.worldmodel.properties.IntProperty;

public class Building
extends Area {
    public static final EnumSet<StandardEntityConstants.Fieryness> BURNING = EnumSet.of(StandardEntityConstants.Fieryness.HEATING, StandardEntityConstants.Fieryness.BURNING, StandardEntityConstants.Fieryness.INFERNO);
    private IntProperty floors;
    private BooleanProperty ignition;
    private IntProperty fieryness;
    private IntProperty brokenness;
    private IntProperty code;
    private IntProperty attributes;
    private IntProperty groundArea;
    private IntProperty totalArea;
    private IntProperty temperature;
    private IntProperty importance;

    public Building(EntityID id) {
        super(id);
        this.floors = new IntProperty((Enum)StandardPropertyURN.FLOORS);
        this.ignition = new BooleanProperty((Enum)StandardPropertyURN.IGNITION);
        this.fieryness = new IntProperty((Enum)StandardPropertyURN.FIERYNESS);
        this.brokenness = new IntProperty((Enum)StandardPropertyURN.BROKENNESS);
        this.code = new IntProperty((Enum)StandardPropertyURN.BUILDING_CODE);
        this.attributes = new IntProperty((Enum)StandardPropertyURN.BUILDING_ATTRIBUTES);
        this.groundArea = new IntProperty((Enum)StandardPropertyURN.BUILDING_AREA_GROUND);
        this.totalArea = new IntProperty((Enum)StandardPropertyURN.BUILDING_AREA_TOTAL);
        this.temperature = new IntProperty((Enum)StandardPropertyURN.TEMPERATURE);
        this.importance = new IntProperty((Enum)StandardPropertyURN.IMPORTANCE);
        this.registerProperties(new Property[]{this.floors, this.ignition, this.fieryness, this.brokenness, this.code, this.attributes, this.groundArea, this.totalArea, this.temperature, this.importance});
    }

    public Building(Building other) {
        super(other);
        this.floors = new IntProperty(other.floors);
        this.ignition = new BooleanProperty(other.ignition);
        this.fieryness = new IntProperty(other.fieryness);
        this.brokenness = new IntProperty(other.brokenness);
        this.code = new IntProperty(other.code);
        this.attributes = new IntProperty(other.attributes);
        this.groundArea = new IntProperty(other.groundArea);
        this.totalArea = new IntProperty(other.totalArea);
        this.temperature = new IntProperty(other.temperature);
        this.importance = new IntProperty(other.importance);
        this.registerProperties(new Property[]{this.floors, this.ignition, this.fieryness, this.brokenness, this.code, this.attributes, this.groundArea, this.totalArea, this.temperature, this.importance});
    }

    protected Entity copyImpl() {
        return new Building(this.getID());
    }

    @Override
    public StandardEntityURN getStandardURN() {
        return StandardEntityURN.BUILDING;
    }

    protected String getEntityName() {
        return "Building";
    }

    @Override
    public Property getProperty(String urn) {
        StandardPropertyURN type;
        try {
            type = StandardPropertyURN.fromString(urn);
        }
        catch (IllegalArgumentException e) {
            return super.getProperty(urn);
        }
        switch (type) {
            case FLOORS: {
                return this.floors;
            }
            case IGNITION: {
                return this.ignition;
            }
            case FIERYNESS: {
                return this.fieryness;
            }
            case BROKENNESS: {
                return this.brokenness;
            }
            case BUILDING_CODE: {
                return this.code;
            }
            case BUILDING_ATTRIBUTES: {
                return this.attributes;
            }
            case BUILDING_AREA_GROUND: {
                return this.groundArea;
            }
            case BUILDING_AREA_TOTAL: {
                return this.totalArea;
            }
            case TEMPERATURE: {
                return this.temperature;
            }
            case IMPORTANCE: {
                return this.importance;
            }
        }
        return super.getProperty(urn);
    }

    public IntProperty getFloorsProperty() {
        return this.floors;
    }

    public int getFloors() {
        return this.floors.getValue();
    }

    public void setFloors(int floors) {
        this.floors.setValue(floors);
    }

    public boolean isFloorsDefined() {
        return this.floors.isDefined();
    }

    public void undefineFloors() {
        this.floors.undefine();
    }

    public BooleanProperty getIgnitionProperty() {
        return this.ignition;
    }

    public boolean getIgnition() {
        return this.ignition.getValue();
    }

    public void setIgnition(boolean ignition) {
        this.ignition.setValue(ignition);
    }

    public boolean isIgnitionDefined() {
        return this.ignition.isDefined();
    }

    public void undefineIgnition() {
        this.ignition.undefine();
    }

    public IntProperty getFierynessProperty() {
        return this.fieryness;
    }

    public int getFieryness() {
        return this.fieryness.getValue();
    }

    public StandardEntityConstants.Fieryness getFierynessEnum() {
        if (!this.fieryness.isDefined()) {
            return null;
        }
        return StandardEntityConstants.Fieryness.values()[this.fieryness.getValue()];
    }

    public void setFieryness(int fieryness) {
        this.fieryness.setValue(fieryness);
    }

    public boolean isFierynessDefined() {
        return this.fieryness.isDefined();
    }

    public void undefineFieryness() {
        this.fieryness.undefine();
    }

    public IntProperty getBrokennessProperty() {
        return this.brokenness;
    }

    public int getBrokenness() {
        return this.brokenness.getValue();
    }

    public void setBrokenness(int brokenness) {
        this.brokenness.setValue(brokenness);
    }

    public boolean isBrokennessDefined() {
        return this.brokenness.isDefined();
    }

    public void undefineBrokenness() {
        this.brokenness.undefine();
    }

    public IntProperty getBuildingCodeProperty() {
        return this.code;
    }

    public int getBuildingCode() {
        return this.code.getValue();
    }

    public StandardEntityConstants.BuildingCode getBuildingCodeEnum() {
        if (!this.code.isDefined()) {
            return null;
        }
        return StandardEntityConstants.BuildingCode.values()[this.code.getValue()];
    }

    public void setBuildingCode(int newCode) {
        this.code.setValue(newCode);
    }

    public boolean isBuildingCodeDefined() {
        return this.code.isDefined();
    }

    public void undefineBuildingCode() {
        this.code.undefine();
    }

    public IntProperty getBuildingAttributesProperty() {
        return this.attributes;
    }

    public int getBuildingAttributes() {
        return this.attributes.getValue();
    }

    public void setBuildingAttributes(int newAttributes) {
        this.attributes.setValue(newAttributes);
    }

    public boolean isBuildingAttributesDefined() {
        return this.attributes.isDefined();
    }

    public void undefineBuildingAttributes() {
        this.attributes.undefine();
    }

    public IntProperty getGroundAreaProperty() {
        return this.groundArea;
    }

    public int getGroundArea() {
        return this.groundArea.getValue();
    }

    public void setGroundArea(int ground) {
        this.groundArea.setValue(ground);
    }

    public boolean isGroundAreaDefined() {
        return this.groundArea.isDefined();
    }

    public void undefineGroundArea() {
        this.groundArea.undefine();
    }

    public IntProperty getTotalAreaProperty() {
        return this.totalArea;
    }

    public int getTotalArea() {
        return this.totalArea.getValue();
    }

    public void setTotalArea(int total) {
        this.totalArea.setValue(total);
    }

    public boolean isTotalAreaDefined() {
        return this.totalArea.isDefined();
    }

    public void undefineTotalArea() {
        this.totalArea.undefine();
    }

    public IntProperty getTemperatureProperty() {
        return this.temperature;
    }

    public int getTemperature() {
        return this.temperature.getValue();
    }

    public void setTemperature(int temperature) {
        this.temperature.setValue(temperature);
    }

    public boolean isTemperatureDefined() {
        return this.temperature.isDefined();
    }

    public void undefineTemperature() {
        this.temperature.undefine();
    }

    public IntProperty getImportanceProperty() {
        return this.importance;
    }

    public int getImportance() {
        return this.importance.getValue();
    }

    public void setImportance(int importance) {
        this.importance.setValue(importance);
    }

    public boolean isImportanceDefined() {
        return this.importance.isDefined();
    }

    public void undefineImportance() {
        this.importance.undefine();
    }

    public boolean isOnFire() {
        if (!this.fieryness.isDefined()) {
            return false;
        }
        return BURNING.contains((Object)this.getFierynessEnum());
    }
}

