/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.util.Arrays;
import java.util.Comparator;
import rescuecore.CannotFindLocationException;
import rescuecore.Memory;
import rescuecore.RescueObject;

public class ConvexHull {
    private int[] xs;
    private int[] ys;
    private int numPoints;
    private HullPoint pivot;

    public ConvexHull(RescueObject[] os, Memory memory) throws CannotFindLocationException {
        if (os.length > 1) {
            double[] tempXs = new double[os.length];
            double[] tempYs = new double[os.length];
            for (int i = 0; i < os.length; ++i) {
                int[] xy = memory.getXY(os[i]);
                tempXs[i] = xy[0];
                tempYs[i] = xy[1];
            }
            int[] hull = this.convexHull(tempXs, tempYs);
            this.xs = new int[hull.length];
            this.ys = new int[hull.length];
            for (int i = 0; i < hull.length; ++i) {
                this.xs[i] = (int)tempXs[hull[i]];
                this.ys[i] = (int)tempYs[hull[i]];
            }
            this.numPoints = hull.length;
        } else {
            this.numPoints = os.length;
            this.xs = new int[this.numPoints];
            this.ys = new int[this.numPoints];
            for (int i = 0; i < this.numPoints; ++i) {
                int[] xy = memory.getXY(os[i]);
                this.xs[i] = xy[0];
                this.ys[i] = xy[1];
            }
        }
    }

    public int[] getXs() {
        return this.xs;
    }

    public int[] getYs() {
        return this.ys;
    }

    public int countPoints() {
        return this.numPoints;
    }

    private int[] convexHull(double[] xs, double[] ys) {
        int highest = 0;
        HullPoint[] points = new HullPoint[xs.length];
        for (int i = 0; i < ys.length; ++i) {
            if (ys[i] > ys[highest]) {
                highest = i;
            }
            points[i] = new HullPoint(i, xs[i], ys[i]);
        }
        HullPoint temp = points[0];
        points[0] = points[highest];
        points[highest] = temp;
        this.pivot = points[0];
        Arrays.sort(points, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == ConvexHull.this.pivot) {
                    return -1;
                }
                if (o2 == ConvexHull.this.pivot) {
                    return 1;
                }
                double angle = ConvexHull.this.ccw((HullPoint)o1, (HullPoint)o2);
                if (angle > 0.0) {
                    return -1;
                }
                return 1;
            }
        });
        HullPoint[] hull = new HullPoint[points.length];
        hull[0] = points[0];
        hull[1] = points[1];
        int hullSize = 2;
        for (int i = 2; i < points.length; ++i) {
            while (this.rightTurn(hull[hullSize - 2], hull[hullSize - 1], points[i])) {
                --hullSize;
            }
            hull[hullSize++] = points[i];
        }
        int[] result = new int[hullSize];
        for (int i = 0; i < hullSize; ++i) {
            result[i] = hull[i].index;
        }
        return result;
    }

    private boolean rightTurn(HullPoint p1, HullPoint p2) {
        return this.rightTurn(p1, this.pivot, p2);
    }

    private boolean rightTurn(HullPoint p1, HullPoint p2, HullPoint p3) {
        return (p1.x - p2.x) * (p3.y - p2.y) - (p1.y - p2.y) * (p3.x - p2.x) > 0.0;
    }

    private double ccw(HullPoint p1, HullPoint p2) {
        return this.ccw(p1, this.pivot, p2);
    }

    private double ccw(HullPoint p1, HullPoint p2, HullPoint p3) {
        return (p1.x - p2.x) * (p3.y - p2.y) - (p1.y - p2.y) * (p3.x - p2.x);
    }

    private class HullPoint {
        int index;
        double x;
        double y;

        HullPoint(int index, double x, double y) {
            this.index = index;
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "Point " + this.index + " (" + this.x + "," + this.y + ")";
        }
    }
}

