/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import rescuecore.tools.simulationrunner.ProcessViewer;
import rescuecore.tools.simulationrunner.RescueProcess;

public class ProcessHandler {
    private RescueProcess[] processes;
    private ProcessViewer viewer;
    private volatile boolean running;
    private volatile Thread startThread;

    public ProcessHandler(RescueProcess[] processes, ProcessViewer viewer) {
        this.processes = processes;
        this.viewer = viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAll() {
        ProcessHandler processHandler = this;
        synchronized (processHandler) {
            this.running = true;
            this.startThread = Thread.currentThread();
        }
        for (int i = 0; i < this.processes.length; ++i) {
            RescueProcess next = this.processes[i];
            if (this.viewer != null) {
                this.viewer.processStarting(i);
            }
            if (!this.running || !next.start()) break;
            if (this.viewer == null) continue;
            this.viewer.processStarted(i);
        }
        boolean finished = false;
        ProcessHandler processHandler2 = this;
        synchronized (processHandler2) {
            this.startThread = null;
            while (this.running && !finished) {
                for (int i = 0; i < this.processes.length; ++i) {
                    RescueProcess next = this.processes[i];
                    if (next.isRunning()) continue;
                    if (this.viewer != null) {
                        this.viewer.processStopped(i);
                    }
                    finished = true;
                    break;
                }
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.stopAllProcesses();
    }

    public synchronized void stopAll() {
        this.running = false;
        if (this.startThread != null) {
            this.startThread.interrupt();
        }
        this.notifyAll();
        while (this.somethingRunning()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private synchronized void stopAllProcesses() {
        for (int i = 0; i < this.processes.length; ++i) {
            RescueProcess next = this.processes[i];
            if (!next.isRunning()) continue;
            System.out.print("Stopping process " + (i + 1) + " of " + this.processes.length + "...");
            next.stop();
            if (this.viewer != null) {
                this.viewer.processStopped(i);
            }
            System.out.println("stopped");
        }
    }

    private synchronized boolean somethingRunning() {
        for (int i = 0; i < this.processes.length; ++i) {
            RescueProcess next = this.processes[i];
            if (!next.isRunning()) continue;
            return true;
        }
        return false;
    }
}

