/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rescuecore.debug.CommandHandler;
import rescuecore.debug.DebugLog;
import rescuecore.debug.DebugPane;
import rescuecore.debug.Handler;
import rescuecore.debug.StringHandler;
import rescuecore.debug.UpdateHandler;

public class Debugger
extends JPanel {
    private Collection<DebugPane> panes;
    private DebugLog log;
    private JTabbedPane tabs = new JTabbedPane(1, 1);
    private JSlider time;

    public Debugger() {
        super(new BorderLayout());
        JPanel bottom = new JPanel();
        JPanel timePanel = new JPanel(new BorderLayout());
        Border b = BorderFactory.createLineBorder(Color.BLACK);
        b = BorderFactory.createTitledBorder(b, "Time Step");
        timePanel.setBorder(b);
        this.time = new JSlider(0, 300, 0);
        this.time.setPaintLabels(true);
        this.time.setPaintTicks(true);
        this.time.setSnapToTicks(true);
        this.time.setMinorTickSpacing(1);
        this.time.setMajorTickSpacing(50);
        JButton left = new JButton(" < ");
        JButton right = new JButton(" > ");
        left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.moveTime(-1);
            }
        });
        right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Debugger.this.moveTime(1);
            }
        });
        this.time.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Debugger.this.setTimeStep(Debugger.this.time.getValue());
            }
        });
        timePanel.add((Component)this.time, "Center");
        timePanel.add((Component)left, "West");
        timePanel.add((Component)right, "East");
        this.add((Component)this.tabs, "Center");
        this.add((Component)timePanel, "South");
    }

    public void init(File file) throws IOException, ClassNotFoundException {
        this.log = new DebugLog(file);
        this.tabs.removeAll();
        Collection<String> names = this.log.getAllNames();
        this.panes = new ArrayList<DebugPane>(names.size());
        for (String next : names) {
            DebugPane pane = this.makeDebugPane(next, this.log);
            this.panes.add(pane);
            this.tabs.add(pane);
        }
        try {
            this.registerHandler(CommandHandler.class);
            this.registerHandler(StringHandler.class);
            this.registerHandler(UpdateHandler.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.time.setMaximum(this.log.getMaxTimestep());
        this.setTimeStep(0);
    }

    public int getTimeStep() {
        return this.time.getValue();
    }

    public void registerHandler(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.registerHandler(Class.forName(className));
    }

    public void registerHandler(Class clazz) throws InstantiationException, IllegalAccessException {
        for (DebugPane next : this.panes) {
            Handler hand = (Handler)clazz.newInstance();
            next.registerHandler(hand);
        }
    }

    public void registerHandler(Handler h) {
        try {
            this.registerHandler(h.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void moveTime(int change) {
        this.time.setValue(this.time.getValue() + change);
    }

    public DebugPane makeDebugPane(String name, DebugLog log) {
        return new DebugPane(log, name);
    }

    private void setTimeStep(int time) {
        for (DebugPane next : this.panes) {
            next.moveToTimeStep(time);
        }
    }

    public static void main(String[] args) {
        Debugger d = null;
        String fileName = null;
        ArrayList<String> handlers = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help")) {
                Debugger.printUsage();
                return;
            }
            if (fileName == null) {
                fileName = args[i];
                continue;
            }
            File f = new File(args[i]);
            if (f.exists()) {
                String nextClass = null;
                try {
                    BufferedReader in = new BufferedReader(new FileReader(f));
                    nextClass = in.readLine();
                    while (nextClass != null) {
                        if (!nextClass.equals("") && !nextClass.startsWith("#")) {
                            handlers.add(nextClass);
                        }
                        nextClass = in.readLine();
                    }
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Error reading file " + args[i] + ": " + e);
                    continue;
                }
            }
            handlers.add(args[i]);
        }
        d = new Debugger();
        File file = null;
        try {
            if (fileName == null) {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    file = chooser.getSelectedFile();
                } else {
                    System.exit(0);
                }
            } else {
                file = new File(fileName);
            }
            d.init(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        for (String next : handlers) {
            try {
                d.registerHandler(next);
            }
            catch (Exception e) {
                System.err.println("Couldn't register handler " + next + ": " + e);
            }
        }
        JFrame frame = new JFrame("Debugger");
        frame.setContentPane(d);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension size = t.getScreenSize();
        frame.setSize((int)size.getWidth(), (int)size.getHeight());
        frame.setVisible(true);
    }

    private static void printUsage() {
        System.out.println("Usage: Debugger [options] [filename [handlers]]");
        System.out.println("Any handlers will be loaded and registered automatically. You can specify handlers as either fully-qualified class names or file names. Each line in each file name should contain the fully-qualified class name of a handler, lines beginning with a # will be ignored");
        System.out.println("Options");
        System.out.println("-h\t--help\tPrint this message");
    }
}

