/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rescuecore.Handy;
import rescuecore.OutputBuffer;
import rescuecore.commands.Command;

public class RescueMessage {
    private List parts = new ArrayList();

    public void append(Command command) {
        this.parts.add(command);
    }

    public int cull(int type, int max) {
        int count = 0;
        Iterator it = this.parts.iterator();
        while (it.hasNext()) {
            Command next = (Command)it.next();
            if ((next.getType() & type) == 0 || ++count <= max) continue;
            it.remove();
        }
        return count;
    }

    public int count(int type) {
        int count = 0;
        for (Command next : this.parts) {
            if ((next.getType() & type) == 0) continue;
            ++count;
        }
        return count;
    }

    public byte[] toByteArray() {
        OutputBuffer out = new OutputBuffer();
        Command[] all = new Command[this.parts.size()];
        this.parts.toArray(all);
        out.writeCommands(all);
        return out.getBytes();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("RescueMessage with ");
        result.append(this.parts.size());
        result.append(this.parts.size() == 1 ? " part" : " parts");
        result.append(": ");
        Iterator it = this.parts.iterator();
        while (it.hasNext()) {
            result.append(Handy.getCommandTypeName(((Command)it.next()).getType()));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

