/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.generator.MapGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.ContinuousUniformGenerator;
import org.uncommons.maths.random.Probability;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Point2D;

public class ManhattanGenerator
implements MapGenerator {
    private static final String GRID_WIDTH_KEY = "generator.manhattan.grid.width";
    private static final String GRID_HEIGHT_KEY = "generator.manhattan.grid.height";
    private static final String GRID_SIZE_KEY = "generator.manhattan.grid.size";
    private static final String ROAD_WIDTH_KEY = "generator.manhattan.road.width";
    private static final String BUILDING_WIDTH_MIN_KEY = "generator.manhattan.building.width.min";
    private static final String BUILDING_HEIGHT_MIN_KEY = "generator.manhattan.building.height.min";
    private static final String BUILDING_SEPARATION_MIN_KEY = "generator.manhattan.building.separation.min";
    private static final String BUILDING_SEPARATION_MAX_KEY = "generator.manhattan.building.separation.max";
    private static final String BUILDING_MIN_SIZE_KEY = "generator.manhattan.building.split.min-size";
    private static final String BUILDING_MAX_SIZE_KEY = "generator.manhattan.building.split.max-size";
    private static final String BUILDING_SPLIT_CHANCE_KEY = "generator.manhattan.building.split.chance";
    private Config config;
    private NumberGenerator<Double> separationGenerator;
    private Probability split;
    private double minSize;
    private double maxSize;
    private double minWidth;
    private double minHeight;
    private GMLMap map;

    public ManhattanGenerator(Config config) {
        this.config = config;
        this.separationGenerator = new ContinuousUniformGenerator(config.getFloatValue(BUILDING_SEPARATION_MIN_KEY), config.getFloatValue(BUILDING_SEPARATION_MAX_KEY), config.getRandom());
        this.split = new Probability(config.getFloatValue(BUILDING_SPLIT_CHANCE_KEY));
        this.minSize = config.getFloatValue(BUILDING_MIN_SIZE_KEY);
        this.maxSize = config.getFloatValue(BUILDING_MAX_SIZE_KEY);
        this.minWidth = config.getFloatValue(BUILDING_WIDTH_MIN_KEY);
        this.minHeight = config.getFloatValue(BUILDING_HEIGHT_MIN_KEY);
    }

    @Override
    public void populate(GMLMap gmlMap) {
        this.map = gmlMap;
        int gridWidth = this.config.getIntValue(GRID_WIDTH_KEY);
        int gridHeight = this.config.getIntValue(GRID_HEIGHT_KEY);
        double gridSize = this.config.getIntValue(GRID_SIZE_KEY);
        double roadWidth = this.config.getIntValue(ROAD_WIDTH_KEY);
        Logger.debug((String)("Generating manhattan map: grid size " + gridWidth + " x " + gridHeight));
        Logger.debug((String)("Grid cell size: " + gridSize + "m"));
        Logger.debug((String)("Road width: " + roadWidth + "m"));
        ArrayList<GMLBuilding> allBuildings = new ArrayList<GMLBuilding>();
        for (int gridX = 0; gridX < gridWidth; ++gridX) {
            for (int gridY = 0; gridY < gridHeight; ++gridY) {
                double cellXMin = (double)gridX * gridSize + roadWidth;
                double cellYMin = (double)gridY * gridSize + roadWidth;
                double cellXMax = (double)(gridX + 1) * gridSize - roadWidth;
                double cellYMax = (double)(gridY + 1) * gridSize - roadWidth;
                GMLBuilding base = this.createBuilding(cellXMin, cellYMin, cellXMax, cellYMax);
                allBuildings.addAll(this.divide(base));
            }
        }
        this.map.removeAllNodes();
        this.map.removeAllEdges();
        this.map.removeAllBuildings();
        for (GMLBuilding next : allBuildings) {
            this.map.add((GMLObject)next);
            for (GMLDirectedEdge edge : next.getEdges()) {
                this.map.add((GMLObject)edge.getEdge());
                this.map.add((GMLObject)edge.getEdge().getStart());
                this.map.add((GMLObject)edge.getEdge().getEnd());
            }
        }
    }

    private Collection<GMLBuilding> divide(GMLBuilding b) {
        HashSet<GMLBuilding> result = new HashSet<GMLBuilding>();
        List<Point2D> vertices = this.coordinatesToVertices(b.getUnderlyingCoordinates());
        double area = GeometryTools2D.computeArea(vertices);
        if (area <= this.minSize) {
            result.add(b);
        } else if (area > this.maxSize || this.split.nextEvent(this.config.getRandom())) {
            double width;
            double xMin = b.getBounds().getMinX();
            double xMax = b.getBounds().getMaxX();
            double yMin = b.getBounds().getMinY();
            double yMax = b.getBounds().getMaxY();
            double height = yMax - yMin;
            if (height > (width = xMax - xMin)) {
                double splitY = (yMax + yMin) / 2.0;
                double topOffset = (Double)this.separationGenerator.nextValue();
                double bottomOffset = (Double)this.separationGenerator.nextValue();
                double topY = splitY + topOffset;
                double bottomY = splitY - bottomOffset;
                if (yMax - topY < this.minHeight || bottomY - yMin < this.minHeight) {
                    result.add(b);
                } else {
                    result.addAll(this.divide(this.createBuilding(xMin, yMin, xMax, bottomY)));
                    result.addAll(this.divide(this.createBuilding(xMin, topY, xMax, yMax)));
                }
            } else {
                double splitX = (xMax + xMin) / 2.0;
                double leftOffset = (Double)this.separationGenerator.nextValue();
                double rightOffset = (Double)this.separationGenerator.nextValue();
                double leftX = splitX - leftOffset;
                double rightX = splitX + rightOffset;
                if (xMax - rightX < this.minWidth || leftX - xMin < this.minWidth) {
                    result.add(b);
                } else {
                    result.addAll(this.divide(this.createBuilding(xMin, yMin, leftX, yMax)));
                    result.addAll(this.divide(this.createBuilding(rightX, yMin, xMax, yMax)));
                }
            }
        } else {
            result.add(b);
        }
        return result;
    }

    private List<Point2D> coordinatesToVertices(List<GMLCoordinates> coords) {
        ArrayList<Point2D> result = new ArrayList<Point2D>(coords.size());
        for (GMLCoordinates c : coords) {
            result.add(new Point2D(c.getX(), c.getY()));
        }
        return result;
    }

    private GMLBuilding createBuilding(double xMin, double yMin, double xMax, double yMax) {
        ArrayList<GMLNode> nodes = new ArrayList<GMLNode>();
        nodes.add(this.map.createNode(xMin, yMin));
        nodes.add(this.map.createNode(xMax, yMin));
        nodes.add(this.map.createNode(xMax, yMax));
        nodes.add(this.map.createNode(xMin, yMax));
        return this.map.createBuildingFromNodes(nodes);
    }
}

