/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import maps.CoordinateConversion;
import maps.gml.GMLCoordinates;
import maps.gml.GMLObject;

public class GMLNode
extends GMLObject {
    private GMLCoordinates coordinates;

    public GMLNode(int id, double x, double y) {
        this(id, new GMLCoordinates(x, y));
    }

    public GMLNode(int id, GMLCoordinates coordinates) {
        super(id);
        this.coordinates = coordinates;
    }

    public GMLCoordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(GMLCoordinates c) {
        if (c == null) {
            throw new IllegalArgumentException("Coordinates cannot be null");
        }
        this.coordinates = c;
    }

    public double getX() {
        return this.coordinates.getX();
    }

    public double getY() {
        return this.coordinates.getY();
    }

    public void convert(CoordinateConversion c) {
        double oldX = this.coordinates.getX();
        double oldY = this.coordinates.getY();
        double newX = c.convertX(oldX);
        double newY = c.convertY(oldY);
        this.coordinates = new GMLCoordinates(newX, newY);
    }

    public String toString() {
        return "GMLNode " + this.getID() + " at " + this.coordinates;
    }
}

