/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import maps.convert.osm2gml.OSMRoadInfo;
import maps.convert.osm2gml.OSMShape;
import maps.osm.OSMNode;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;

public class OSMIntersectionInfo
implements OSMShape {
    private OSMNode centre;
    private List<RoadAspect> roads;
    private List<Point2D> vertices;
    private Area area;

    public OSMIntersectionInfo(OSMNode centre) {
        this.centre = centre;
        this.roads = new ArrayList<RoadAspect>();
    }

    public void addRoadSegment(OSMRoadInfo road) {
        if (road.getFrom() == this.centre && road.getTo() == this.centre) {
            System.out.println("Degenerate road found");
        } else {
            this.roads.add(new RoadAspect(road, this.centre));
        }
    }

    public void process(double sizeOf1m) {
        this.vertices = new ArrayList<Point2D>();
        if (this.roads.size() > 1) {
            this.processRoads(sizeOf1m);
        } else {
            this.processSingleRoad(sizeOf1m);
            this.area = null;
        }
    }

    public OSMNode getCentre() {
        return this.centre;
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public List<Point2D> getVertices() {
        return this.vertices;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("IntersectionInfo (centre ");
        result.append(this.centre);
        result.append(") [");
        Iterator<Point2D> it = this.vertices.iterator();
        while (it.hasNext()) {
            result.append(it.next().toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append("]");
        if (this.area == null) {
            result.append(" (degenerate)");
        }
        return result.toString();
    }

    private void processRoads(double sizeOf1m) {
        RoadAspect first;
        Point2D centrePoint = new Point2D(this.centre.getLongitude(), this.centre.getLatitude());
        CounterClockwiseSort sort = new CounterClockwiseSort(centrePoint);
        Collections.sort(this.roads, sort);
        Iterator<RoadAspect> it = this.roads.iterator();
        RoadAspect previous = first = it.next();
        while (it.hasNext()) {
            RoadAspect next = it.next();
            Point2D p = this.findIncomingRoadIntersection(previous, next, centrePoint, sizeOf1m);
            this.vertices.add(p);
            previous = next;
        }
        Point2D p = this.findIncomingRoadIntersection(previous, first, centrePoint, sizeOf1m);
        this.vertices.add(p);
        if (this.vertices.size() > 2) {
            Iterator<Point2D> ix = this.vertices.iterator();
            Point2D point = ix.next();
            Path2D.Double path = new Path2D.Double();
            path.moveTo(point.getX(), point.getY());
            while (ix.hasNext()) {
                point = ix.next();
                path.lineTo(point.getX(), point.getY());
            }
            path.closePath();
            this.area = new Area(path.createTransformedShape(null));
        } else {
            this.area = null;
        }
    }

    private Point2D findIncomingRoadIntersection(RoadAspect first, RoadAspect second, Point2D centrePoint, double sizeOf1m) {
        Point2D start2Point;
        Line2D line2;
        OSMNode firstNode = first.getFarNode();
        OSMNode secondNode = second.getFarNode();
        Point2D firstPoint = new Point2D(firstNode.getLongitude(), firstNode.getLatitude());
        Point2D secondPoint = new Point2D(secondNode.getLongitude(), secondNode.getLatitude());
        Vector2D firstVector = centrePoint.minus(firstPoint);
        Vector2D secondVector = centrePoint.minus(secondPoint);
        Vector2D firstNormal = firstVector.getNormal().normalised().scale(-7.0 * sizeOf1m / 2.0);
        Vector2D secondNormal = secondVector.getNormal().normalised().scale(7.0 * sizeOf1m / 2.0);
        Point2D start1Point = firstPoint.plus(firstNormal);
        Line2D line1 = new Line2D(start1Point, firstVector);
        Point2D intersection = GeometryTools2D.getIntersectionPoint((Line2D)line1, (Line2D)(line2 = new Line2D(start2Point = secondPoint.plus(secondNormal), secondVector)));
        if (intersection == null) {
            intersection = centrePoint.plus(firstNormal);
        }
        first.setRightEnd(intersection);
        second.setLeftEnd(intersection);
        return intersection;
    }

    private void processSingleRoad(double sizeOf1m) {
        Point2D centrePoint = new Point2D(this.centre.getLongitude(), this.centre.getLatitude());
        RoadAspect road = this.roads.iterator().next();
        OSMNode node = road.getFarNode();
        Point2D nodePoint = new Point2D(node.getLongitude(), node.getLatitude());
        Vector2D nodeVector = centrePoint.minus(nodePoint);
        Vector2D nodeNormal = nodeVector.getNormal().normalised().scale(-7.0 * sizeOf1m / 2.0);
        Vector2D nodeNormal2 = nodeNormal.scale(-1.0);
        Point2D start1Point = nodePoint.plus(nodeNormal);
        Point2D start2Point = nodePoint.plus(nodeNormal2);
        Line2D line1 = new Line2D(start1Point, nodeVector);
        Line2D line2 = new Line2D(start2Point, nodeVector);
        Point2D end1 = line1.getPoint(1.0);
        Point2D end2 = line2.getPoint(1.0);
        road.setRightEnd(end1);
        road.setLeftEnd(end2);
    }

    private static class CounterClockwiseSort
    implements Comparator<RoadAspect> {
        private Point2D centre;

        public CounterClockwiseSort(Point2D centre) {
            this.centre = centre;
        }

        @Override
        public int compare(RoadAspect first, RoadAspect second) {
            double d2;
            double d1 = this.score(first);
            if (d1 < (d2 = this.score(second))) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }

        public double score(RoadAspect aspect) {
            OSMNode node = aspect.getFarNode();
            Point2D point = new Point2D(node.getLongitude(), node.getLatitude());
            Vector2D v = point.minus(this.centre);
            double sin = v.getX() / v.getLength();
            double cos = v.getY() / v.getLength();
            if (Double.isNaN(sin) || Double.isNaN(cos)) {
                System.out.println(v);
                System.out.println(v.getLength());
            }
            return this.convert(sin, cos);
        }

        private double convert(double sin, double cos) {
            if (sin >= 0.0 && cos >= 0.0) {
                return sin;
            }
            if (sin >= 0.0 && cos < 0.0) {
                return 2.0 - sin;
            }
            if (sin < 0.0 && cos < 0.0) {
                return 2.0 - sin;
            }
            if (sin < 0.0 && cos >= 0.0) {
                return 4.0 + sin;
            }
            throw new IllegalArgumentException("This should be impossible! What's going on? sin=" + sin + ", cos=" + cos);
        }
    }

    private static class RoadAspect {
        private boolean forward;
        private OSMRoadInfo road;

        RoadAspect(OSMRoadInfo road, OSMNode intersection) {
            this.road = road;
            this.forward = intersection == road.getTo();
        }

        OSMRoadInfo getRoad() {
            return this.road;
        }

        OSMNode getFarNode() {
            return this.forward ? this.road.getFrom() : this.road.getTo();
        }

        void setLeftEnd(Point2D p) {
            if (this.forward) {
                this.road.setToLeft(p);
            } else {
                this.road.setFromRight(p);
            }
        }

        void setRightEnd(Point2D p) {
            if (this.forward) {
                this.road.setToRight(p);
            } else {
                this.road.setFromLeft(p);
            }
        }
    }
}

