/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.Set;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.TemporaryIntersection;
import maps.convert.osm2gml.TemporaryMap;
import maps.convert.osm2gml.TemporaryObject;
import maps.convert.osm2gml.TemporaryRoad;

public class ComputePassableEdgesStep
extends ConvertStep {
    private TemporaryMap map;

    public ComputePassableEdgesStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Computing passable edges";
    }

    @Override
    protected void step() {
        this.setProgressLimit(this.map.getAllEdges().size());
        int count = 0;
        for (Edge next : this.map.getAllEdges()) {
            int roadCount = 0;
            Set<TemporaryObject> attached = this.map.getAttachedObjects(next);
            for (TemporaryObject o : attached) {
                if (!(o instanceof TemporaryRoad) && !(o instanceof TemporaryIntersection)) continue;
                ++roadCount;
            }
            if (roadCount > 1) {
                for (TemporaryObject o1 : attached) {
                    for (TemporaryObject o2 : attached) {
                        if (o1 == o2) continue;
                        o1.setNeighbour(next, o2);
                    }
                }
                ++count;
            }
            this.bumpProgress();
        }
        this.setStatus("Made " + count + " edges passable");
    }
}

