/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import rescuecore2.config.Config;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.PoliceForce;

public class MiscParameters {
    private Config config;
    private Random rng;
    private Map<BuildingCode, Map<BrokennessDegree, BuildingClass>> buildingClasses;
    private DamageType collapseDamage;
    private DamageType buryDamage;
    private DamageType fireDamage;

    public MiscParameters(Config config) {
        this.config = config;
        this.rng = config.getRandom();
        this.initBuildingData();
        this.initInjuryData();
    }

    public boolean shouldBuryAgent(Building b) {
        if (!b.isBuildingCodeDefined() || !b.isBrokennessDefined() || b.getBrokenness() == 0) {
            return false;
        }
        BuildingClass clazz = this.getBuildingClass(b);
        return clazz.shouldBury();
    }

    public int getBuriedness(Building b) {
        if (!b.isBuildingCodeDefined() || !b.isBrokennessDefined() || b.getBrokenness() == 0) {
            return 0;
        }
        BuildingClass clazz = this.getBuildingClass(b);
        return clazz.getAgentBuriedness();
    }

    public int getCollapseDamage(Building b, Human agent) {
        if (!b.isBuildingCodeDefined() || !b.isBrokennessDefined() || b.getBrokenness() == 0) {
            return 0;
        }
        BuildingClass clazz = this.getBuildingClass(b);
        Injury injury = clazz.getCollapseInjury();
        return this.collapseDamage.getDamage(injury, agent);
    }

    public int getBuryDamage(Building b, Human agent) {
        if (!b.isBuildingCodeDefined() || !b.isBrokennessDefined() || b.getBrokenness() == 0) {
            return 0;
        }
        BuildingClass clazz = this.getBuildingClass(b);
        Injury injury = clazz.getBuryInjury();
        return this.buryDamage.getDamage(injury, agent);
    }

    public int getFireDamage(Building b, Human agent) {
        if (!b.isBuildingCodeDefined()) {
            return 0;
        }
        BuildingClass clazz = this.getBuildingClass(b);
        Injury injury = clazz.getFireInjury();
        return this.fireDamage.getDamage(injury, agent);
    }

    private void initBuildingData() {
        this.buildingClasses = new EnumMap<BuildingCode, Map<BrokennessDegree, BuildingClass>>(BuildingCode.class);
        for (BuildingCode code : BuildingCode.values()) {
            EnumMap<BrokennessDegree, BuildingClass> codeMap = new EnumMap<BrokennessDegree, BuildingClass>(BrokennessDegree.class);
            for (BrokennessDegree degree : BrokennessDegree.values()) {
                codeMap.put(degree, new BuildingClass(this.config, code, degree));
            }
            this.buildingClasses.put(code, codeMap);
        }
    }

    private void initInjuryData() {
        this.collapseDamage = new DamageType(this.config, "collapse");
        this.buryDamage = new DamageType(this.config, "bury");
        this.fireDamage = new DamageType(this.config, "fire");
    }

    private BuildingClass getBuildingClass(Building b) {
        BuildingCode code = BuildingCode.values()[b.getBuildingCode()];
        BrokennessDegree degree = BrokennessDegree.getBrokennessDegree(b);
        return this.buildingClasses.get((Object)code).get((Object)degree);
    }

    private static class DamageType {
        private Map<Injury, Integer> damage = new EnumMap<Injury, Integer>(Injury.class);
        private double ambulanceMultiplier;
        private double policeMultiplier;
        private double fireMultiplier;

        public DamageType(Config config, String type) {
            this.damage.put(Injury.NONE, 0);
            this.damage.put(Injury.SLIGHT, config.getIntValue("misc.injury." + type + ".slight"));
            this.damage.put(Injury.SERIOUS, config.getIntValue("misc.injury." + type + ".serious"));
            this.damage.put(Injury.CRITICAL, config.getIntValue("misc.injury." + type + ".critical"));
            this.ambulanceMultiplier = config.getFloatValue("misc.injury." + type + ".multiplier.ambulance");
            this.policeMultiplier = config.getFloatValue("misc.injury." + type + ".multiplier.police");
            this.fireMultiplier = config.getFloatValue("misc.injury." + type + ".multiplier.fire");
        }

        public int getDamage(Injury injury, Human agent) {
            int result = this.damage.get((Object)injury);
            if (agent instanceof AmbulanceTeam) {
                return (int)((double)result * this.ambulanceMultiplier);
            }
            if (agent instanceof PoliceForce) {
                return (int)((double)result * this.policeMultiplier);
            }
            if (agent instanceof FireBrigade) {
                return (int)((double)result * this.fireMultiplier);
            }
            return result;
        }
    }

    private static enum Injury {
        NONE,
        SLIGHT,
        SERIOUS,
        CRITICAL;

    }

    private static enum BrokennessDegree {
        NONE(0, 0),
        PARTIAL(1, 25),
        HALF(26, 50),
        ALL(51, 100);

        private int min;
        private int max;

        private BrokennessDegree(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static BrokennessDegree getBrokennessDegree(Building b) {
            int brokenness = b.isBrokennessDefined() ? b.getBrokenness() : 0;
            for (BrokennessDegree next : BrokennessDegree.values()) {
                if (brokenness < next.min || brokenness > next.max) continue;
                return next;
            }
            return NONE;
        }
    }

    private static enum BuildingCode {
        WOOD,
        STEEL,
        CONCRETE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    private class BuildingClass {
        private double buriedProbability;
        private int initialBuriedness;
        private Map<Injury, Double> collapseInjuryProbability;
        private Map<Injury, Double> buryInjuryProbability;
        private Map<Injury, Double> fireInjuryProbability;

        public BuildingClass(Config config, BuildingCode code, BrokennessDegree degree) {
            this.buriedProbability = config.getFloatValue("misc.buriedness." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".rate");
            this.initialBuriedness = config.getIntValue("misc.buriedness." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".value");
            this.collapseInjuryProbability = new EnumMap<Injury, Double>(Injury.class);
            this.buryInjuryProbability = new EnumMap<Injury, Double>(Injury.class);
            this.fireInjuryProbability = new EnumMap<Injury, Double>(Injury.class);
            this.collapseInjuryProbability.put(Injury.SLIGHT, config.getFloatValue("misc.injury.collapse." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".slight"));
            this.collapseInjuryProbability.put(Injury.SERIOUS, config.getFloatValue("misc.injury.collapse." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".serious"));
            this.collapseInjuryProbability.put(Injury.CRITICAL, config.getFloatValue("misc.injury.collapse." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".critical"));
            this.buryInjuryProbability.put(Injury.SLIGHT, config.getFloatValue("misc.injury.bury." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".slight"));
            this.buryInjuryProbability.put(Injury.SERIOUS, config.getFloatValue("misc.injury.bury." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".serious"));
            this.buryInjuryProbability.put(Injury.CRITICAL, config.getFloatValue("misc.injury.bury." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".critical"));
            this.fireInjuryProbability.put(Injury.SLIGHT, config.getFloatValue("misc.injury.fire." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".slight"));
            this.fireInjuryProbability.put(Injury.SERIOUS, config.getFloatValue("misc.injury.fire." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".serious"));
            this.fireInjuryProbability.put(Injury.CRITICAL, config.getFloatValue("misc.injury.fire." + (Object)((Object)code) + "." + (Object)((Object)degree) + ".critical"));
        }

        public int getAgentBuriedness() {
            return this.initialBuriedness;
        }

        public boolean shouldBury() {
            return MiscParameters.this.rng.nextDouble() < this.buriedProbability;
        }

        public Injury getCollapseInjury() {
            return this.getInjury(this.collapseInjuryProbability);
        }

        public Injury getBuryInjury() {
            return this.getInjury(this.buryInjuryProbability);
        }

        public Injury getFireInjury() {
            return this.getInjury(this.fireInjuryProbability);
        }

        private Injury getInjury(Map<Injury, Double> table) {
            double d = MiscParameters.this.rng.nextDouble();
            double d1 = table.get((Object)Injury.SLIGHT);
            double d2 = table.get((Object)Injury.SERIOUS) + d1;
            double d3 = table.get((Object)Injury.CRITICAL) + d2;
            if (d < d1) {
                return Injury.SLIGHT;
            }
            if (d < d2) {
                return Injury.SERIOUS;
            }
            if (d < d3) {
                return Injury.CRITICAL;
            }
            return Injury.NONE;
        }
    }
}

