/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class LazyMap<K, V>
implements Map<K, V> {
    private Map<K, V> downstream;

    public LazyMap() {
        this(new HashMap());
    }

    public LazyMap(Map<K, V> downstream) {
        this.downstream = downstream;
    }

    public abstract V createValue();

    @Override
    public void clear() {
        this.downstream.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.downstream.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.downstream.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.downstream.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LazyMap && ((Object)((LazyMap)o).downstream).equals(this.downstream);
    }

    @Override
    public V get(Object key) {
        V result = this.downstream.get(key);
        if (result == null) {
            try {
                result = this.createValue();
                this.downstream.put(key, result);
            }
            catch (ClassCastException e) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        return ((Object)this.downstream).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.downstream.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.downstream.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.downstream.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.downstream.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.downstream.remove(key);
    }

    @Override
    public int size() {
        return this.downstream.size();
    }

    @Override
    public Collection<V> values() {
        return this.downstream.values();
    }
}

