/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rescuecore2.messages.AbstractMessageComponent;
import rescuecore2.misc.EncodingTools;

public class IntListComponent
extends AbstractMessageComponent {
    private List<Integer> data;

    public IntListComponent(String name) {
        super(name);
        this.data = new ArrayList<Integer>();
    }

    public IntListComponent(String name, List<Integer> data) {
        super(name);
        this.data = new ArrayList<Integer>(data);
    }

    public List<Integer> getValues() {
        return Collections.unmodifiableList(this.data);
    }

    public void setValues(List<Integer> newData) {
        this.data = new ArrayList<Integer>(newData);
    }

    public void setValues(int ... newData) {
        this.data = new ArrayList<Integer>();
        for (int i : newData) {
            this.data.add(i);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.data.size(), out);
        for (Integer next : this.data) {
            EncodingTools.writeInt32((int)next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.data.clear();
        int count = EncodingTools.readInt32(in);
        for (int i = 0; i < count; ++i) {
            this.data.add(EncodingTools.readInt32(in));
        }
    }

    public String toString() {
        return this.getName() + " = " + this.data.toString();
    }
}

