/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore2.log.LogException;
import rescuecore2.log.LogRecord;
import rescuecore2.log.RecordType;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.ChangeSet;

public class UpdatesRecord
implements LogRecord {
    private int time;
    private ChangeSet changes;

    public UpdatesRecord(int time, ChangeSet changes) {
        this.time = time;
        this.changes = changes;
    }

    public UpdatesRecord(InputStream in) throws IOException, LogException {
        this.read(in);
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.UPDATES;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.time, out);
        this.changes.write(out);
    }

    @Override
    public void read(InputStream in) throws IOException, LogException {
        this.time = EncodingTools.readInt32(in);
        this.changes = new ChangeSet();
        this.changes.read(in);
    }

    public int getTime() {
        return this.time;
    }

    public ChangeSet getChangeSet() {
        return this.changes;
    }
}

