/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import rescuecore2.log.LogException;
import rescuecore2.log.LogRecord;
import rescuecore2.log.RecordType;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.DefaultWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class InitialConditionsRecord
implements LogRecord {
    private WorldModel<Entity> model;

    public InitialConditionsRecord(WorldModel<? extends Entity> model) {
        this.model = DefaultWorldModel.create();
        this.model.merge(model.getAllEntities());
    }

    public InitialConditionsRecord(InputStream in) throws IOException, LogException {
        this.read(in);
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.INITIAL_CONDITIONS;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Collection<Entity> all = this.model.getAllEntities();
        EncodingTools.writeInt32(all.size(), out);
        for (Entity e : all) {
            EncodingTools.writeEntity(e, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException, LogException {
        this.model = DefaultWorldModel.create();
        int size = EncodingTools.readInt32(in);
        for (int i = 0; i < size; ++i) {
            Entity e = EncodingTools.readEntity(in);
            if (e == null) {
                throw new LogException("Could not read entity from stream");
            }
            this.model.addEntity(e);
        }
    }

    public WorldModel<Entity> getWorldModel() {
        return this.model;
    }
}

