/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import rescuecore2.messages.Command;
import rescuecore2.misc.Pair;
import rescuecore2.misc.gui.DrawingTools;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.messages.AKClear;
import rescuecore2.standard.messages.AKExtinguish;
import rescuecore2.standard.messages.AKLoad;
import rescuecore2.standard.messages.AKMove;
import rescuecore2.standard.messages.AKRescue;
import rescuecore2.standard.messages.AKUnload;
import rescuecore2.standard.view.StandardViewLayer;
import rescuecore2.view.Icons;
import rescuecore2.view.RenderedObject;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class CommandLayer
extends StandardViewLayer {
    private static final int SIZE = 15;
    private static final Color CLEAR_COLOUR = new Color(0, 0, 255, 128);
    private static final Color RESCUE_COLOUR = new Color(255, 255, 255, 128);
    private static final Color LOAD_COLOUR = new Color(255, 255, 255, 128);
    private static final Color UNLOAD_COLOUR = new Color(255, 255, 255, 128);
    private static final double ARROW_ANGLE = Math.toRadians(135.0);
    private static final double ARROW_LENGTH = 5.0;
    private Graphics2D g;
    private ScreenTransform t;
    private Collection<Command> commands = new ArrayList<Command>();
    private boolean renderMove = true;
    private boolean renderExtinguish = true;
    private boolean renderClear = true;
    private boolean renderLoad = true;
    private boolean renderUnload = true;
    private boolean renderRescue = true;
    private RenderMoveAction renderMoveAction = new RenderMoveAction();
    private RenderExtinguishAction renderExtinguishAction = new RenderExtinguishAction();
    private RenderClearAction renderClearAction = new RenderClearAction();
    private RenderRescueAction renderRescueAction = new RenderRescueAction();
    private RenderLoadAction renderLoadAction = new RenderLoadAction();
    private RenderUnloadAction renderUnloadAction = new RenderUnloadAction();

    public void setRenderMove(boolean render) {
        this.renderMove = render;
        this.renderMoveAction.update();
    }

    public void setRenderExtinguish(boolean render) {
        this.renderExtinguish = render;
        this.renderExtinguishAction.update();
    }

    public void setRenderClear(boolean render) {
        this.renderClear = render;
        this.renderClearAction.update();
    }

    public void setRenderLoad(boolean render) {
        this.renderLoad = render;
        this.renderLoadAction.update();
    }

    public void setRenderUnload(boolean render) {
        this.renderUnload = render;
        this.renderUnloadAction.update();
    }

    public void setRenderRescue(boolean render) {
        this.renderRescue = render;
        this.renderRescueAction.update();
    }

    public List<JMenuItem> getPopupMenuItems() {
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        result.add(new JMenuItem(this.renderMoveAction));
        result.add(new JMenuItem(this.renderClearAction));
        result.add(new JMenuItem(this.renderExtinguishAction));
        result.add(new JMenuItem(this.renderRescueAction));
        result.add(new JMenuItem(this.renderLoadAction));
        result.add(new JMenuItem(this.renderUnloadAction));
        return result;
    }

    public String getName() {
        return "Commands";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle2D view(Object ... objects) {
        Collection<Command> collection = this.commands;
        synchronized (collection) {
            this.commands.clear();
            return super.view(objects);
        }
    }

    @Override
    protected void viewObject(Object o) {
        super.viewObject(o);
        if (o instanceof Command) {
            this.commands.add((Command)o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RenderedObject> render(Graphics2D graphics, ScreenTransform transform, int width, int height) {
        Collection<Command> collection = this.commands;
        synchronized (collection) {
            ArrayList<RenderedObject> result = new ArrayList<RenderedObject>();
            this.g = graphics;
            this.t = transform;
            for (Command next : this.commands) {
                if (this.renderMove && next instanceof AKMove) {
                    this.renderMove((AKMove)next);
                }
                if (this.renderExtinguish && next instanceof AKExtinguish) {
                    this.renderExtinguish((AKExtinguish)next);
                }
                if (this.renderClear && next instanceof AKClear) {
                    this.renderClear((AKClear)next);
                }
                if (this.renderRescue && next instanceof AKRescue) {
                    this.renderRescue((AKRescue)next);
                }
                if (this.renderLoad && next instanceof AKLoad) {
                    this.renderLoad((AKLoad)next);
                }
                if (!this.renderUnload || !(next instanceof AKUnload)) continue;
                this.renderUnload((AKUnload)next);
            }
            return result;
        }
    }

    private void renderMove(AKMove move) {
        this.g.setColor(Color.BLACK);
        List<EntityID> path = move.getPath();
        if (path.isEmpty()) {
            return;
        }
        Iterator<EntityID> it = path.iterator();
        StandardEntity first = (StandardEntity)this.world.getEntity(it.next());
        Pair<Integer, Integer> firstLocation = first.getLocation((WorldModel<? extends StandardEntity>)this.world);
        int startX = this.t.xToScreen((double)((Integer)firstLocation.first()).intValue());
        int startY = this.t.yToScreen((double)((Integer)firstLocation.second()).intValue());
        while (it.hasNext()) {
            StandardEntity next = (StandardEntity)this.world.getEntity(it.next());
            Pair<Integer, Integer> nextLocation = next.getLocation((WorldModel<? extends StandardEntity>)this.world);
            int nextX = this.t.xToScreen((double)((Integer)nextLocation.first()).intValue());
            int nextY = this.t.yToScreen((double)((Integer)nextLocation.second()).intValue());
            this.g.drawLine(startX, startY, nextX, nextY);
            DrawingTools.drawArrowHeads((int)startX, (int)startY, (int)nextX, (int)nextY, (Graphics)this.g);
            startX = nextX;
            startY = nextY;
        }
    }

    private void renderExtinguish(AKExtinguish ex) {
        StandardEntity fb = (StandardEntity)this.world.getEntity(ex.getAgentID());
        StandardEntity target = (StandardEntity)this.world.getEntity(ex.getTarget());
        Pair<Integer, Integer> fbLocation = fb.getLocation((WorldModel<? extends StandardEntity>)this.world);
        Pair<Integer, Integer> targetLocation = target.getLocation((WorldModel<? extends StandardEntity>)this.world);
        int fbX = this.t.xToScreen((double)((Integer)fbLocation.first()).intValue());
        int fbY = this.t.yToScreen((double)((Integer)fbLocation.second()).intValue());
        int bX = this.t.xToScreen((double)((Integer)targetLocation.first()).intValue());
        int bY = this.t.yToScreen((double)((Integer)targetLocation.second()).intValue());
        this.g.setColor(Color.BLUE);
        this.g.drawLine(fbX, fbY, bX, bY);
    }

    private void renderClear(AKClear clear) {
        this.renderHumanAction((StandardEntity)this.world.getEntity(clear.getAgentID()), CLEAR_COLOUR, null);
    }

    private void renderRescue(AKRescue rescue) {
        this.renderHumanAction((StandardEntity)this.world.getEntity(rescue.getAgentID()), RESCUE_COLOUR, null);
    }

    private void renderLoad(AKLoad load) {
        this.renderHumanAction((StandardEntity)this.world.getEntity(load.getAgentID()), LOAD_COLOUR, "L");
    }

    private void renderUnload(AKUnload unload) {
        this.renderHumanAction((StandardEntity)this.world.getEntity(unload.getAgentID()), UNLOAD_COLOUR, "U");
    }

    private void renderHumanAction(StandardEntity entity, Color colour, String s) {
        Pair<Integer, Integer> location = entity.getLocation((WorldModel<? extends StandardEntity>)this.world);
        int x = this.t.xToScreen((double)((Integer)location.first()).intValue()) - 7;
        int y = this.t.yToScreen((double)((Integer)location.second()).intValue()) - 7;
        Ellipse2D.Double shape = new Ellipse2D.Double(x, y, 15.0, 15.0);
        this.g.setColor(colour);
        this.g.fill(shape);
        if (s != null) {
            this.g.setColor(Color.BLACK);
            FontMetrics metrics = this.g.getFontMetrics();
            int width = metrics.stringWidth(s);
            int height = metrics.getHeight();
            x = this.t.xToScreen((double)((Integer)location.first()).intValue());
            y = this.t.yToScreen((double)((Integer)location.second()).intValue());
            this.g.drawString(s, x - width / 2, y + height / 2);
        }
    }

    private final class RenderUnloadAction
    extends AbstractAction {
        public RenderUnloadAction() {
            super("Show unload commands");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandLayer.this.setRenderUnload(!CommandLayer.this.renderUnload);
            CommandLayer.this.component.repaint();
        }

        void update() {
            this.putValue("SwingSelectedKey", CommandLayer.this.renderUnload);
            this.putValue("SmallIcon", CommandLayer.this.renderUnload ? Icons.TICK : Icons.CROSS);
        }
    }

    private final class RenderLoadAction
    extends AbstractAction {
        public RenderLoadAction() {
            super("Show load commands");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandLayer.this.setRenderLoad(!CommandLayer.this.renderLoad);
            CommandLayer.this.component.repaint();
        }

        void update() {
            this.putValue("SwingSelectedKey", CommandLayer.this.renderLoad);
            this.putValue("SmallIcon", CommandLayer.this.renderLoad ? Icons.TICK : Icons.CROSS);
        }
    }

    private final class RenderRescueAction
    extends AbstractAction {
        public RenderRescueAction() {
            super("Show rescue commands");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandLayer.this.setRenderRescue(!CommandLayer.this.renderRescue);
            CommandLayer.this.component.repaint();
        }

        void update() {
            this.putValue("SwingSelectedKey", CommandLayer.this.renderRescue);
            this.putValue("SmallIcon", CommandLayer.this.renderRescue ? Icons.TICK : Icons.CROSS);
        }
    }

    private final class RenderExtinguishAction
    extends AbstractAction {
        public RenderExtinguishAction() {
            super("Show extinguish commands");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandLayer.this.setRenderExtinguish(!CommandLayer.this.renderExtinguish);
            CommandLayer.this.component.repaint();
        }

        void update() {
            this.putValue("SwingSelectedKey", CommandLayer.this.renderExtinguish);
            this.putValue("SmallIcon", CommandLayer.this.renderExtinguish ? Icons.TICK : Icons.CROSS);
        }
    }

    private final class RenderClearAction
    extends AbstractAction {
        public RenderClearAction() {
            super("Show clear commands");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandLayer.this.setRenderClear(!CommandLayer.this.renderClear);
            CommandLayer.this.component.repaint();
        }

        void update() {
            this.putValue("SwingSelectedKey", CommandLayer.this.renderClear);
            this.putValue("SmallIcon", CommandLayer.this.renderClear ? Icons.TICK : Icons.CROSS);
        }
    }

    private final class RenderMoveAction
    extends AbstractAction {
        public RenderMoveAction() {
            super("Show move commands");
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandLayer.this.setRenderMove(!CommandLayer.this.renderMove);
            CommandLayer.this.component.repaint();
        }

        void update() {
            this.putValue("SwingSelectedKey", CommandLayer.this.renderMove);
            this.putValue("SmallIcon", CommandLayer.this.renderMove ? Icons.TICK : Icons.CROSS);
        }
    }
}

