/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.EntityID;

public final class SampleSearch {
    private Map<EntityID, Set<EntityID>> graph;

    public SampleSearch(StandardWorldModel world) {
        LazyMap<EntityID, Set<EntityID>> neighbours = new LazyMap<EntityID, Set<EntityID>>(){

            public Set<EntityID> createValue() {
                return new HashSet<EntityID>();
            }
        };
        for (StandardEntity next : world) {
            if (!(next instanceof Area)) continue;
            List areaNeighbours = ((Area)next).getNeighbours();
            ((Set)neighbours.get(next.getID())).addAll(areaNeighbours);
        }
        this.setGraph((Map<EntityID, Set<EntityID>>)neighbours);
    }

    public SampleSearch(Map<EntityID, Set<EntityID>> graph) {
        this.setGraph(graph);
    }

    public void setGraph(Map<EntityID, Set<EntityID>> newGraph) {
        this.graph = newGraph;
    }

    public Map<EntityID, Set<EntityID>> getGraph() {
        return this.graph;
    }

    public List<EntityID> breadthFirstSearch(EntityID start, EntityID ... goals) {
        return this.breadthFirstSearch(start, Arrays.asList(goals));
    }

    public List<EntityID> breadthFirstSearch(EntityID start, Collection<EntityID> goals) {
        LinkedList<EntityID> open = new LinkedList<EntityID>();
        HashMap<EntityID, EntityID> ancestors = new HashMap<EntityID, EntityID>();
        open.add(start);
        EntityID next = null;
        boolean found = false;
        ancestors.put(start, start);
        block0: do {
            if (this.isGoal(next = (EntityID)open.remove(0), goals)) {
                found = true;
                break;
            }
            Collection neighbours = this.graph.get(next);
            if (neighbours.isEmpty()) continue;
            for (EntityID neighbour : neighbours) {
                if (this.isGoal(neighbour, goals)) {
                    ancestors.put(neighbour, next);
                    next = neighbour;
                    found = true;
                    continue block0;
                }
                if (ancestors.containsKey(neighbour)) continue;
                open.add(neighbour);
                ancestors.put(neighbour, next);
            }
        } while (!found && !open.isEmpty());
        if (!found) {
            return null;
        }
        EntityID current = next;
        LinkedList<EntityID> path = new LinkedList<EntityID>();
        do {
            path.add(0, current);
            current = (EntityID)ancestors.get(current);
            if (current != null) continue;
            throw new RuntimeException("Found a node with no ancestor! Something is broken.");
        } while (current != start);
        return path;
    }

    private boolean isGoal(EntityID e, Collection<EntityID> test) {
        return test.contains(e);
    }
}

